/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.RedshiftDatasetConfig;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RedshiftSQLDialect
extends GenericSQLDialect {
    private boolean useOldStyleDatetimeTz = true;

    public void setOldStyleDatetimeTz(boolean useOldStyleDatetimeTz) {
        this.useOldStyleDatetimeTz = useOldStyleDatetimeTz;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float4", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "float8", new Integer[]{7, 2});
            }
            case DATE: {
                boolean useOldStyle = false;
                if (dataset != null && dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
                    useOldStyle = this.useOldStyleDatetimeTz;
                    useOldStyle = dataset.getDkuPropertiesAsParams().getBoolParam("dku.useTimestampForDatetimeTz", useOldStyle);
                }
                if (useOldStyle) {
                    return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp", new Integer[]{91, 2014});
                }
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamptz", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, 2014});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91, 2014});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        assert (!ifNotExist);
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append(")");
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        if (dataset.getParams() instanceof RedshiftDatasetConfig) {
            RedshiftDatasetConfig datasetParams = dataset.getParamsAs(RedshiftDatasetConfig.class);
            switch (datasetParams.distributionStyle) {
                case AUTO: {
                    break;
                }
                case EVEN: {
                    sb.append(" DISTSTYLE EVEN ");
                    break;
                }
                case ALL: {
                    sb.append(" DISTSTYLE ALL ");
                    break;
                }
                case KEY: {
                    sb.append(" DISTSTYLE KEY DISTKEY (" + this.quoteIdentifier(datasetParams.distributionKeyColumn) + ") ");
                }
            }
            RedshiftDatasetConfig.SortStyle effectiveSortKey = datasetParams.sortKey;
            ArrayList effectiveSortColumns = Lists.newArrayList(datasetParams.sortKeyColumns);
            if (scheme.isPartitioned()) {
                effectiveSortKey = RedshiftDatasetConfig.SortStyle.COMPOUND;
                effectiveSortColumns = Lists.newArrayList();
                for (String partitionColumnName : scheme.getDimensionNames()) {
                    effectiveSortColumns.add(partitionColumnName);
                }
                effectiveSortColumns.addAll(datasetParams.sortKeyColumns);
            }
            boolean first = true;
            switch (effectiveSortKey) {
                case NONE: {
                    break;
                }
                case COMPOUND: {
                    sb.append(" COMPOUND SORTKEY(");
                    for (String column : effectiveSortColumns) {
                        if (!first) {
                            sb.append(",");
                        }
                        first = false;
                        sb.append(this.quoteIdentifier(column));
                    }
                    sb.append(") ");
                    break;
                }
                case INTERLEAVED: {
                    sb.append(" INTERLEAVED SORTKEY(");
                    for (String column : effectiveSortColumns) {
                        if (!first) {
                            sb.append(", ");
                        }
                        first = false;
                        sb.append(this.quoteIdentifier(column));
                    }
                    sb.append(") ");
                }
            }
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public boolean hasCaseInsensitiveColumns() {
        return true;
    }

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String useUTCTimezone() {
        return "SET TIMEZONE TO 'UTC'";
    }

    @Override
    public String quoteDate(String str) {
        return this.quoteString(str) + "::TIMESTAMPTZ";
    }

    @Override
    public String quoteDateOnly(String str) {
        return this.quoteString(str) + "::DATE";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return this.quoteString(str) + "::TIMESTAMP";
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM (" + inputDateExpression + "))";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM (" + inputDateExpression + "))";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM (" + inputDateExpression + "))";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEK FROM (" + inputDateExpression + "))";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM (" + inputDateExpression + "))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM (" + inputDateExpression + "))";
            }
            case DAY_OF_WEEK: {
                return "((EXTRACT(DOW FROM (" + inputDateExpression + "))+6)%7+1)";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM (" + inputDateExpression + "))";
            }
            case MILLIS_FROM_EPOCH: {
                return "(EXTRACT(EPOCH FROM (" + inputDateExpression + ")) * 1000::numeric)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Redshift", part));
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + inputDateExpression + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + inputDateExpression + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + inputDateExpression + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + inputDateExpression + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + inputDateExpression + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + inputDateExpression + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + inputDateExpression + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + inputDateExpression + ")";
            }
        }
        throw new NotImplementedException();
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.dateTrunc(inputDateExpression, rounding);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return "CAST(" + this.dateTrunc(inputDateExpression, rounding) + " AS DATE)";
    }

    private String castToTimestamp(String toCast) {
        return "CAST(" + toCast + " AS TIMESTAMP)";
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type dssType;
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String interval = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = dssType = args[0].outputType != null ? args[0].outputType.dssType : null;
                if (dssType == null) {
                    dssType = Type.DATE;
                }
                String dateAddSql = "DATEADD(" + unit + ", CAST(" + interval + " AS BIGINT), " + RedshiftSQLDialect.this.castToTimestamp(datetimeNoTz) + ")";
                if (dssType == Type.DATEONLY) {
                    return dateAddSql + "::DATE";
                }
                if (dssType == Type.DATE) {
                    return dateAddSql + "::TIMESTAMPTZ";
                }
                return dateAddSql;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.MOD.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String op1Expr = this.toSQLNoBrackets(args[0]);
                String op2Expr = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.MOD.priority);
                return "CAST(" + op1Expr + " AS NUMERIC) % " + op2Expr;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "WEEK": {
                        String e = "CASE WHEN " + start + " < " + end + " AND (" + start + " - DATE_TRUNC('day', " + start + ")) > (" + end + " - DATE_TRUNC('day', " + end + ")) THEN -1 ELSE 0 END";
                        e = e + " + CASE WHEN " + start + " > " + end + " AND (" + start + " - DATE_TRUNC('day', " + start + ")) < (" + end + " - DATE_TRUNC('day', " + end + ")) THEN 1 ELSE 0 END";
                        e = e + " + DATEDIFF(day, " + RedshiftSQLDialect.this.castToTimestamp(start) + ", " + RedshiftSQLDialect.this.castToTimestamp(end) + ")";
                        return "(" + e + ")/7";
                    }
                    case "YEAR": 
                    case "MONTH": 
                    case "DAY": 
                    case "HOUR": 
                    case "MINUTE": {
                        String e = "CASE WHEN " + start + " < " + end + " AND (" + start + " - DATE_TRUNC('" + unit + "', " + start + ")) > (" + end + " - DATE_TRUNC('" + unit + "', " + end + ")) THEN -1 ELSE 0 END";
                        e = e + " + CASE WHEN " + start + " > " + end + " AND (" + start + " - DATE_TRUNC('" + unit + "', " + start + ")) < (" + end + " - DATE_TRUNC('" + unit + "', " + end + ")) THEN 1 ELSE 0 END";
                        e = e + " + DATEDIFF(" + unit + ", " + RedshiftSQLDialect.this.castToTimestamp(start) + ", " + RedshiftSQLDialect.this.castToTimestamp(end) + ")";
                        return e;
                    }
                    case "SECOND": {
                        return "DATEDIFF(second, " + RedshiftSQLDialect.this.castToTimestamp(start) + ", " + RedshiftSQLDialect.this.castToTimestamp(end) + ")";
                    }
                }
                throw new IllegalArgumentException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                if (args.length >= 3 && args[2] != null) {
                    return "CAST((" + this.toSQLNoBrackets(args[0]) + " AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ")  AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[2]);
                }
                if (args[1] != null) {
                    return "CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP) AT TIME ZONE " + this.toSQLNoBrackets(args[1]);
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MSS_TO_DATEONLY_EPOCH, "MSS_TO_EPOCH", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "((" + RedshiftSQLDialect.this.dateonlyPartExpression(this.toSQLNoBrackets(args[0]), DatePart.SECOND_FROM_EPOCH) + ") * 1000::numeric)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MSS_TO_DATETIMENOTZ_EPOCH, "MSS_TO_EPOCH", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "((" + RedshiftSQLDialect.this.datetimenotzPartExpression(this.toSQLNoBrackets(args[0]), DatePart.SECOND_FROM_EPOCH) + ") * 1000::numeric)";
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "(", ")::TIMESTAMPTZ"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "(", ")::DATE"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "(", ")::TIMESTAMP"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ") OVER ()";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String second;
                this.validateNumberOfParameters(args);
                String first = this.toSQLNoBrackets(args[0]);
                if (args.length == 2) {
                    second = this.toSQLNoBrackets(args[1]);
                } else if (args.length > 2) {
                    second = this.apply(Arrays.copyOfRange(args, 1, args.length));
                } else {
                    throw new IllegalArgumentException("CONCAT requires at least two arguments");
                }
                return "CONCAT(" + first + ", " + second + ")";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.SUBSTR, "SUBSTRING", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String column = this.toSQLNoBrackets(args[0]);
                QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                String separator = (String)separatorExpr.value;
                if (separator == null) {
                    return "LISTAGG(CAST(" + column + " as VARCHAR), '') WITHIN GROUP (ORDER BY 0)";
                }
                return "LISTAGG(CAST(" + column + " as VARCHAR), " + this.toSQLNoBrackets(separatorExpr) + ") WITHIN GROUP (ORDER BY 0)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "(REGEXP_COUNT(" + input + ", " + regex + ") > 0)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = RedshiftSQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "to_date(" + input + ",'" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP(" + input + ",'" + sqlFormat + "')::TIMESTAMP";
                    }
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return "TO_TIMESTAMP(" + input + ",'" + sqlFormat + "')";
                    }
                    return "CONVERT_TIMEZONE('" + timezoneId + "', 'UTC', TO_TIMESTAMP(" + input + ",'" + sqlFormat + "')::TIMESTAMP)::TIMESTAMPTZ";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = RedshiftSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "TO_CHAR(" + input + ",'" + sqlFormat + "')";
                    }
                    return "TO_CHAR((" + input + ") at time zone '" + StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC") + "','" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAST, "LEAST", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(a -> this.toSQLNoBrackets((QueryAst.Expr)a)).collect(Collectors.toList());
                String least = "LEAST(" + funcArgs.stream().collect(Collectors.joining(", ")) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return least;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + least + " END";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.GREATEST, "GREATEST", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs > 0;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                List funcArgs = Lists.newArrayList((Object[])args).stream().map(a -> this.toSQLNoBrackets((QueryAst.Expr)a)).collect(Collectors.toList());
                String greatest = "GREATEST(" + funcArgs.stream().collect(Collectors.joining(", ")) + ")";
                List nullableArgs = Lists.newArrayList((Object[])args).stream().filter(a -> !(a instanceof QueryAst.ConstExpr) || ((QueryAst.ConstExpr)a).value == null).collect(Collectors.toList());
                if (nullableArgs.isEmpty()) {
                    return greatest;
                }
                return "CASE WHEN " + nullableArgs.stream().map(a -> "(" + this.toSQLNoBrackets((QueryAst.Expr)a) + ") IS NULL").collect(Collectors.joining(" OR ")) + " THEN NULL ELSE " + greatest + " END";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.DEC2HEX, "TO_HEX", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(STRPOS(", ", COALESCE(", ", '')) - 1)", false));
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NOW, "CURRENT_TIMESTAMP", QueryUtils.Arity.NO_ARG){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "CURRENT_TIMESTAMP";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String pattern = this.toSQLNoBrackets(args[1]);
                String replacement = this.toSQLNoBrackets(args[2]);
                char caseSensitive = 'c';
                if (args.length > 3) {
                    caseSensitive = this.getParamAs(args[3], Boolean.class) != false ? (char)'i' : 'c';
                }
                return String.format("REGEXP_REPLACE(%s, %s, %s, 1, '%c')", column, pattern, replacement, Character.valueOf(caseSensitive));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return RedshiftSQLDialect.this.generateRegExpSubstr(this, args);
            }
        });
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR LENGTH(" + expr + ") = 0 THEN NULL ELSE DECODE(LOWER(" + expr + "), '" + Joiner.on((String)"', true, '").join((Iterable)this.booleanTrueValues) + "', true, false) END";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        if (connData.getSchemaSearchPath() != null && connData.getSchemaSearchPath().length() > 0) {
            SQLUtils.safeExec(conn, "SET search_path TO " + connData.getSchemaSearchPath());
        }
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return ApplicationConfigurator.getParams().getIntParam("dku.sql.redshift.maxVarcharLength", Integer.valueOf(65000));
    }

    @Override
    public int getDefaultVarcharLen() {
        return ApplicationConfigurator.getParams().getIntParam("dku.sql.redshift.defaultVarcharLength", Integer.valueOf(65000));
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 127;
    }

    @Override
    public boolean tableExists(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, String projectKey) throws Exception {
        return super.tableExists(authCtx, connData, conn, RedshiftSQLDialect.toLowerCase(catalog), RedshiftSQLDialect.toLowerCase(schema), RedshiftSQLDialect.toLowerCase(table), projectKey);
    }

    @Override
    public List<String> getTableTypesWithoutOverrides(SQLDialect.GetTableTypesReason reason) {
        List<String> tableTypes = super.getTableTypesWithoutOverrides(reason);
        tableTypes.add("EXTERNAL TABLE");
        return tableTypes;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.FIRST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.LAST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE && forParsing) {
            throw new IllegalArgumentException("Parsing timezone not implemented in db");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            String text = forParsing ? part.text.replaceAll("[a-zA-Z]", " ") : part.text;
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(text).matches()) {
                return "\"" + text.replace("\"", "\\\\\"") + "\"";
            }
            return text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MONTH && !part.numeric && !part.shortened) {
            return "FMMonth";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && !part.numeric && !part.shortened) {
            return "FMDay";
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot use clock hour in date formats");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE && forParsing) {
            return SQLCapability.nok("Cannot parse with timezone");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getId() {
        return "Redshift";
    }

    @Override
    public boolean supportsTransactionalDdl() {
        return true;
    }

    @Override
    public SQLDialect.RegexSupport regexSupport() {
        return SQLDialect.RegexSupport.BASIC;
    }

    @Override
    public boolean supportsNonCapturingGroups() {
        return false;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return false;
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT schemaname, viewname FROM pg_views WHERE viewname LIKE 'dssview@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "schemaname", " AND schemaname NOT IN ('pg_catalog', 'information_schema')");
    }

    @VisibleForTesting
    String getCreateTempTableFieldsSQL(Dataset dataset, Schema temporaryTableSchema) {
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SchemaColumn col : temporaryTableSchema.getColumns()) {
            if (!first) {
                sb.append(",");
            }
            String type = col.getType() == Type.TINYINT || col.getType() == Type.SMALLINT ? "bigint" : this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl;
            sb.append("\t").append(this.quoteIdentifier(col.getName())).append(" ").append(type).append("\n");
            first = false;
        }
        return sb.toString();
    }

    public String generateTempTableStatementSQL(String tempTableName, Dataset outputDataset, Schema temporaryTableSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TEMPORARY TABLE " + this.getQuotedTableFullName("", "", tempTableName) + " (\n");
        sb.append(this.getCreateTempTableFieldsSQL(outputDataset, temporaryTableSchema));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (seed != null) {
            return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            return SQLDialect.RandomSampleClauseLocation.WHERE;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            sb.append("rand() < ").append(sample.ratio);
        } else if (sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || sample.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            sb.append("rand()");
        } else {
            throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for Redshift");
        }
        return sb.toString();
    }

    @Override
    public void fillWithEmpty(PreparedStatement ps2, Dataset dataset, Type dssType, int colIdx) throws SQLException {
        SchemaColumn sc = new SchemaColumn("", dssType);
        sc.maxLength = 0;
        int mainSQLType = this.getSQLType((SchemaColumn)sc, (Dataset)dataset).mainSQLType;
        if (mainSQLType == 2014) {
            try {
                ps2.setNull(colIdx, mainSQLType);
            }
            catch (Exception e) {
                ps2.setNull(colIdx, 93);
            }
        } else {
            super.fillWithEmpty(ps2, dataset, dssType, colIdx);
        }
    }

    @Override
    public String getLogClause(double base, String argument) {
        return this.getLogClauseForSingleArgumentLog(base, argument);
    }

    public static String toLowerCase(String table) {
        return table == null ? null : table.toLowerCase();
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, false, false, true);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, false, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, true);
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        return "COMMENT ON TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages));
    }

    @Override
    public String generateColumnCommentStatementQuery(DatabaseObjectKey tableKey, SchemaColumn column, InfoMessage.InfoMessages messages) {
        return "COMMENT ON COLUMN " + this.getQuotedColumnFullName(tableKey.catalog, tableKey.schema, tableKey.name, column.getName()) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages)) + ";";
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return 256;
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return 256;
    }
}

