/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.SchemaMismatchException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DenodoSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaOptions;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.hproxy.model.hive.TableSchema;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SchemaReader {
    private static Map<Integer, String> jdbcTypeNames;
    private static Logger logger;

    public static synchronized String jdbcTypeName(int code) {
        String name;
        if (jdbcTypeNames == null) {
            jdbcTypeNames = new HashMap<Integer, String>();
            for (Field field : Types.class.getFields()) {
                try {
                    jdbcTypeNames.put((Integer)field.get(null), field.getName());
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            jdbcTypeNames.put(100, "BINARY_FLOAT");
            jdbcTypeNames.put(101, "BINARY_DOUBLE");
            jdbcTypeNames.put(-101, "TIMESTAMPTZ");
            jdbcTypeNames.put(-102, "TIMESTAMPLTZ");
        }
        return (name = jdbcTypeNames.get(code)) != null ? name : "JDBC[" + code + "]";
    }

    public static void isManagedSchemaCompatible(Schema datasetSchema, Dataset dataset, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, SQLConnectionProvider.SQLConnectionData data) throws Exception {
        String query;
        SQLDialect dialect = data.getDialect();
        if (dialect.supportsResultSetMetadataOnPreparedStatement(query = "SELECT * FROM " + dialect.getQuotedTableFullName(catalog, schema, table))) {
            try (PreparedStatement ps2 = conn.prepareStatement(dialect.alterQueryForResultSetMetadataOnPreparedStatement(query));){
                SchemaReader.isManagedSchemaCompatible(datasetSchema, dataset, dialect.getResultSetMetadataOnPreparedStatement(ps2), dialect, "dataset", "table");
            }
        }
        try (Statement s = SQLUtils.getProperlyStreamableStatement(data, conn);){
            SQLUtils.setMaxRows(s, 10);
            logger.info((Object)("Executing query to check schema compatibility : " + query));
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
                try {
                    s.cancel();
                }
                catch (SQLException e) {
                    logger.info((Object)"Could not cancel query", (Throwable)e);
                }
            });){
                s.execute(dialect.getLimitedQuery(query, 10L));
                try (ResultSet rs2 = s.getResultSet();){
                    SchemaReader.isManagedSchemaCompatible(datasetSchema, dataset, rs2.getMetaData(), dialect, "dataset", "table");
                }
            }
        }
    }

    public static void isManagedSchemaCompatible(Schema datasetSchema, Dataset dataset, ResultSetMetaData rsmd, SQLDialect dialect, String inName, String outName) throws SQLException, SchemaMismatchException {
        if (datasetSchema.getColumns().size() != rsmd.getColumnCount()) {
            throw new SchemaMismatchException(String.format("Invalid number of columns, %d in %s, %d in %s", datasetSchema.getColumns().size(), inName, rsmd.getColumnCount(), outName));
        }
        StringBuilder errorMessage = new StringBuilder();
        for (int i = 0; i < datasetSchema.getColumns().size(); ++i) {
            DSSTypeSQLMapping schemaColSQL;
            String rsColName;
            SchemaColumn schemaCol = (SchemaColumn)datasetSchema.getColumns().get(i);
            String schemaColName = schemaCol.getName();
            if (!schemaColName.equalsIgnoreCase(rsColName = SchemaUtils.getColumnNameToUse(dialect, rsmd, i + 1))) {
                errorMessage.append(String.format("Name mismatch for column %d : '%s' in %s, '%s' in %s%n", i + 1, schemaColName, inName, rsColName, outName));
            }
            if ((schemaColSQL = dialect.getSQLType(schemaCol, dataset)).isCompatible(rsmd.getColumnType(i + 1))) continue;
            errorMessage.append(String.format("Type mismatch for column %d (%s) : '%s' in %s, '%s'(%d:%s) in %s%n", i + 1, rsColName, SchemaReader.jdbcTypeName(schemaColSQL.mainSQLType), inName, SchemaReader.jdbcTypeName(rsmd.getColumnType(i + 1)), rsmd.getColumnType(i + 1), rsmd.getColumnTypeName(i + 1), outName));
        }
        if (!errorMessage.isEmpty()) {
            throw new SchemaMismatchException(errorMessage.toString());
        }
    }

    public static Schema resultSetToSchema(ResultSet rs2, SQLConnectionProvider.SQLConnectionData connData, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws SQLException {
        Schema schema = new Schema();
        SQLDialect dialect = connData.getDialect();
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        while (rs2.next()) {
            int sqlScale;
            int sqlType = rs2.getInt(5);
            String sqlTypeName = rs2.getString(6);
            int sqlPrecision = rs2.getInt(7);
            String sqlScaleStr = rs2.getString(9);
            String colName = rs2.getString(4);
            String comment = rs2.getString(12);
            int n = sqlScale = StringUtils.isBlank((String)sqlScaleStr) ? 0 : Integer.parseInt(sqlScaleStr);
            if (connData.getType().equals((Object)ConnectionUtils.SQLConnectionType.BIGQUERY) && "null".equals(comment)) {
                comment = null;
            }
            colName = dialect.cleanupColumnName(colName);
            SchemaColumn col = SchemaReader.getSchemaColumn(transmogrifier, dialect, colName, null, sqlType, sqlTypeName, sqlPrecision, sqlScale, -1, datetimenotzReadMode, dateonlyReadMode, targetSchema);
            col.comment = comment;
            col.originalType = sqlTypeName;
            schema.getColumns().add(col);
        }
        return schema;
    }

    public static Schema metadataToSchema(SQLDialect dialect, ResultSetMetaData rsmd, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) throws SQLException {
        return SchemaReader.metadataToSchema(dialect, rsmd, datetimenotzReadMode, dateonlyReadMode, null);
    }

    public static Schema metadataToSchema(SQLDialect dialect, ResultSetMetaData rsmd, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws SQLException {
        Schema ret = new Schema();
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            int sqlType = rsmd.getColumnType(i + 1);
            int sqlPrecision = rsmd.getPrecision(i + 1);
            int sqlScale = rsmd.getScale(i + 1);
            int sqlSize = rsmd.getColumnDisplaySize(i + 1);
            String sqlTypeName = rsmd.getColumnTypeName(i + 1);
            String nameToUse = SchemaUtils.getColumnNameToUse(dialect, rsmd, i + 1);
            String label = rsmd.getColumnLabel(i + 1);
            SchemaColumn rawColumn = SchemaReader.getSchemaColumn(transmogrifier, dialect, nameToUse, label, sqlType, sqlTypeName, sqlPrecision, sqlScale, sqlSize, datetimenotzReadMode, dateonlyReadMode, targetSchema);
            ret.getColumns().add(rawColumn);
        }
        return ret;
    }

    public static SchemaColumn getSchemaColumn(StringTransmogrifier transmogrifier, SQLDialect dialect, String name, String label, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, int sqlSize, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws SQLException {
        if (targetSchema != null && !targetSchema.hasColumn(name)) {
            String lookingFor = name;
            SchemaColumn sc = targetSchema.getColumns().stream().filter(col -> col.getName().toUpperCase().equals(lookingFor) || col.getName().toLowerCase().equals(lookingFor)).findFirst().orElse(null);
            if (sc != null) {
                name = sc.getName();
            }
        }
        if (dialect instanceof DenodoSQLDialect && sqlType == 91) {
            sqlTypeName = "DATE";
        }
        SchemaColumn rawColumn = dialect.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
        Type dkuType = rawColumn.getType();
        logger.debug((Object)("metadataToSchema: name=" + name + " label=" + label + " sqlType=" + sqlTypeName + " [" + sqlType + "(" + sqlPrecision + "," + sqlScale + ")] sqlSize=" + sqlSize + " dkuType=" + String.valueOf(dkuType) + " (len:" + rawColumn.maxLength + ")"));
        if (rawColumn.getType() == Type.STRING && rawColumn.getMaxLength() < 0 && sqlSize > 0 && sqlPrecision == 0) {
            SchemaColumn rawColumnWithAcceptableLength = new SchemaColumn(rawColumn);
            rawColumnWithAcceptableLength.withMaxLength(dialect.getMaxPossibleVarcharLen() + 1);
            DSSTypeSQLMapping sqlTypeMapping = dialect.getSQLType(rawColumnWithAcceptableLength, null);
            if (sqlTypeMapping == null || sqlTypeMapping.compatibleSQLTypes.contains(sqlType)) {
                rawColumn.maxLength = sqlSize;
            }
        }
        String cleaned = name;
        if (targetSchema == null) {
            cleaned = dialect.cleanupColumnName(name);
        } else if (!targetSchema.hasColumn(name) && !targetSchema.hasColumn(cleaned = SchemaReader.cleanupColumnNameForSchema(name))) {
            cleaned = dialect.cleanupColumnName(name);
        }
        cleaned = transmogrifier.transmogrify(cleaned);
        rawColumn.setName(cleaned);
        rawColumn.originalType = sqlTypeName;
        return rawColumn;
    }

    public static SchemaInfo metadataToSchemaInfo(ConnectionUtils.SQLConnectionType type, ResultSetMetaData rsmd) throws SQLException {
        SchemaInfo ret = new SchemaInfo();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            boolean isColWithUnknownTz = false;
            int sqlType = rsmd.getColumnType(i + 1);
            String sqlTypeName = rsmd.getColumnTypeName(i + 1);
            if (sqlType == 91) {
                isColWithUnknownTz = true;
            } else if (sqlType == 93) {
                if (type == ConnectionUtils.SQLConnectionType.POSTGRESQL || type == ConnectionUtils.SQLConnectionType.ALLOYDB || type == ConnectionUtils.SQLConnectionType.DATABRICKSLAKEBASE) {
                    if ("timestamp".equalsIgnoreCase(sqlTypeName)) {
                        isColWithUnknownTz = true;
                    }
                } else if (type == ConnectionUtils.SQLConnectionType.ORACLE) {
                    isColWithUnknownTz = true;
                } else if (type == ConnectionUtils.SQLConnectionType.MYSQL && "datetime".equalsIgnoreCase(sqlTypeName)) {
                    isColWithUnknownTz = true;
                }
            }
            ret.hasColsWithUnknownTz |= isColWithUnknownTz;
        }
        return ret;
    }

    public static Schema getQuerySchema(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String query, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        return SchemaReader.getQuerySchemaWithInfo((AuthCtx)authCtx, (SQLConnectionProvider.SQLConnectionData)data, (SQLConnectionProvider.SQLConnectionWrapper)conn, (String)query, null, (AbstractSQLDatasetHandler.ReadTemporalMode)datetimenotzReadMode, (AbstractSQLDatasetHandler.ReadTemporalMode)dateonlyReadMode, (Schema)targetSchema).schema;
    }

    public static Schema getQuerySchema(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String query, String[] sqlStatements, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        return SchemaReader.getQuerySchemaWithInfo((AuthCtx)authCtx, (SQLConnectionProvider.SQLConnectionData)data, (SQLConnectionProvider.SQLConnectionWrapper)conn, (String)query, (String[])sqlStatements, (AbstractSQLDatasetHandler.ReadTemporalMode)datetimenotzReadMode, (AbstractSQLDatasetHandler.ReadTemporalMode)dateonlyReadMode, (Schema)targetSchema).schema;
    }

    public static SchemaWithInfo getQuerySchemaWithInfo(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String query, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        return SchemaReader.getQuerySchemaWithInfo(authCtx, data, conn, query, null, datetimenotzReadMode, dateonlyReadMode, targetSchema);
    }

    public static SchemaWithInfo tryGetTableSchemaWithInfoAndComments(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema, SQLUtils.SQLTable tableFound) throws Exception {
        SQLDialect dialect = connData.getDialect();
        if (dialect.isSchemaAware() && StringUtils.isBlank((String)schema) || dialect.isCatalogAware() && StringUtils.isBlank((String)catalog)) {
            if (tableFound != null) {
                schema = tableFound.getSchemaNullIfBlank();
                catalog = tableFound.getCatalog();
                logger.info((Object)("No schema or catalog provided, using table found, querying schema with schema=" + schema + " catalog=" + catalog));
                return SchemaReader.getTableSchemaWithInfoAndComments(authCtx, conn, conn.getMetaData(), catalog, schema, table, datetimenotzReadMode, dateonlyReadMode, targetSchema);
            }
            return SchemaReader.getTableSchemaWithInfo(authCtx, connData, conn, catalog, schema, table, datetimenotzReadMode, dateonlyReadMode, targetSchema);
        }
        return SchemaReader.getTableSchemaWithInfoAndComments(authCtx, conn, conn.getMetaData(), catalog, schema, table, datetimenotzReadMode, dateonlyReadMode, targetSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaWithInfo getTableSchemaWithInfoAndComments(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionWrapper conn, DatabaseMetaData metadata, String catalog, String schema, String table, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        SchemaWithInfo schemaWithInfo = new SchemaWithInfo();
        SQLConnectionProvider.SQLConnectionData connData = conn.getConnectionData();
        AbstractSQLConnection connection = connData.getConnection();
        if (connData.getDialect().supportsDirectSchemaRetrieval()) {
            SchemaOptions options = new SchemaOptions().withDatetimenotzReadMode(datetimenotzReadMode).withDateonlyReadMode(dateonlyReadMode);
            schemaWithInfo.schema = connData.getDialect().directRetrieveSchema(authCtx, connection, catalog, schema, table, options);
            if (connData.getDialect().supportsTablePartitionInfoRetrieval()) {
                schemaWithInfo.tablePartitionInfo = connData.getDialect().retrieveTablePartitionInfo(authCtx, connection, catalog, schema, table);
            }
        } else {
            String tableSearchPattern = connData.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(table);
            String schemaSearchPattern = connData.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
            schemaSearchPattern = connData.getDialect().postProcessSchemaPatternForJDBCMetadataSearch(schemaSearchPattern);
            logger.info((Object)("Querying meta columns with catalog=" + catalog + " schemaPattern=" + schemaSearchPattern + " tablePattern=" + tableSearchPattern));
            Boolean oracleRemarksReportingEnabled = SQLUtils.getRemarksReportingForOracle(conn);
            if (oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
                SQLUtils.setRemarksReportingForOracle(conn, true);
            }
            if (connData.getDialect() instanceof RedshiftSQLDialect) {
                tableSearchPattern = RedshiftSQLDialect.toLowerCase(tableSearchPattern);
                schemaSearchPattern = RedshiftSQLDialect.toLowerCase(schemaSearchPattern);
                catalog = RedshiftSQLDialect.toLowerCase(catalog);
            }
            try (ResultSet set = metadata.getColumns(catalog, schemaSearchPattern, tableSearchPattern, "%");){
                schemaWithInfo.schema = SchemaReader.resultSetToSchema(set, connData, datetimenotzReadMode, dateonlyReadMode, targetSchema);
            }
            finally {
                if (oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
                    SQLUtils.setRemarksReportingForOracle(conn, false);
                }
            }
        }
        return schemaWithInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SchemaWithInfo getQuerySchemaWithInfo(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String query, String[] sqlStatements, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        try {
            Object stmt;
            int selectStatementIndex;
            Splitter splitter = new Splitter(data.getDialect().getSemicolonExclusionPortionFinders());
            if (sqlStatements == null || sqlStatements.length == 0) {
                sqlStatements = splitter.split(query);
            }
            if ((selectStatementIndex = SQLUtils.findLastSelectStatement(sqlStatements, splitter)) < 0) {
                logger.info((Object)"SELECT statement not found, assuming it's the last one");
                selectStatementIndex = sqlStatements.length - 1;
            }
            for (int i = 0; i < selectStatementIndex; ++i) {
                String statementSql = sqlStatements[i];
                if (SQLUtils.isDMLStatement(statementSql = splitter.stripComments(statementSql).trim())) continue;
                stmt = SQLUtils.getProperlyStreamableStatement(conn.getConnectionData(), conn);
                try {
                    logger.info((Object)("Executing pre-query statement : " + statementSql));
                    stmt.execute(statementSql);
                    continue;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            try {
                SchemaWithInfo schemaWithInfoFromHive;
                Schema schema2;
                if (data.getDialect().supportsDirectSchemaRetrieval() && (schema2 = data.getDialect().directRetrieveSchema(authCtx, data.getConnection(), query, new SchemaOptions().withDatetimenotzReadMode(datetimenotzReadMode).withDateonlyReadMode(dateonlyReadMode))) != null) {
                    SchemaWithInfo schemaWithInfo = new SchemaWithInfo();
                    schemaWithInfo.schema = schema2;
                    stmt = schemaWithInfo;
                    return stmt;
                }
                if (data.getDialect().supportsResultSetMetadataOnPreparedStatement(query)) {
                    SchemaWithInfo schema2 = SchemaReader.getQuerySchemaWithInfoWithPreparedStatement(data, conn, query, datetimenotzReadMode, dateonlyReadMode, sqlStatements, selectStatementIndex, targetSchema);
                    return schema2;
                }
                if (data.getType() == ConnectionUtils.SQLConnectionType.HIVESERVER2 && (schemaWithInfoFromHive = SchemaReader.getQuerySchemaWithInfoFromDescribeFormatted(data, conn, sqlStatements, selectStatementIndex, datetimenotzReadMode, dateonlyReadMode)) != null) {
                    SchemaWithInfo i = schemaWithInfoFromHive;
                    return i;
                }
                SchemaWithInfo schemaWithInfo = SchemaReader.getQuerySchemaWithInfoWithStatement(data, conn, datetimenotzReadMode, dateonlyReadMode, sqlStatements, selectStatementIndex, targetSchema);
                return schemaWithInfo;
            }
            finally {
                int i = selectStatementIndex + 1;
                while (true) {
                    if (i >= sqlStatements.length) {
                    }
                    String statementSql = sqlStatements[i];
                    if (!SQLUtils.isDMLStatement(statementSql = splitter.stripComments(statementSql).trim())) {
                        try (Statement stmt2 = conn.createStatement();){
                            logger.info((Object)("Executing post-query statement : " + statementSql));
                            stmt2.execute(statementSql);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            throw ExceptionUtils.newSQLExceptionWithNestedMessages((SQLException)e);
        }
    }

    private static SchemaWithInfo getQuerySchemaWithInfoWithStatement(SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, String[] statementSqls, int selectStatementIndex, Schema targetSchema) throws Exception {
        Statement s = null;
        try {
            SchemaWithInfo schemaWithInfo;
            block26: {
                String lquery = data.getDialect().getLimitedQuery(statementSqls[selectStatementIndex], 10L);
                s = SQLUtils.getProperlyStreamableStatement(data, conn);
                SQLUtils.setMaxRows(s, 10);
                Statement finalS = s;
                FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
                    try {
                        finalS.cancel();
                    }
                    catch (SQLException e) {
                        logger.info((Object)"Could not interrupt query", (Throwable)e);
                    }
                });
                try {
                    logger.info((Object)("Executing detect statement : " + lquery));
                    s.execute(lquery);
                    SchemaWithInfo schemaWithInfo2 = new SchemaWithInfo();
                    try (ResultSet rs2 = s.getResultSet();){
                        schemaWithInfo2.schema = SchemaReader.metadataToSchema(data.getDialect(), rs2.getMetaData(), datetimenotzReadMode, dateonlyReadMode, targetSchema);
                        schemaWithInfo2.schemaInfo = SchemaReader.metadataToSchemaInfo(data.getType(), rs2.getMetaData());
                    }
                    schemaWithInfo = schemaWithInfo2;
                    if (aborter == null) break block26;
                }
                catch (Throwable throwable) {
                    if (aborter != null) {
                        try {
                            aborter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                aborter.close();
            }
            return schemaWithInfo;
        }
        finally {
            try {
                if (s != null) {
                    s.cancel();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Could not cancel test SQL statement", (Throwable)e);
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Could not close test SQL statement", (Throwable)e);
            }
        }
    }

    private static SchemaWithInfo getQuerySchemaWithInfoWithPreparedStatement(SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String query, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, String[] statementSqls, int selectStatementIndex, Schema targetSchema) throws Exception {
        logger.info((Object)("Using optimized method for getQuerySchema on query --" + query + "--"));
        logger.info((Object)("SELECT statement is n." + selectStatementIndex + ": --" + statementSqls[selectStatementIndex] + "--"));
        String sqlForMetadata = data.getDialect().alterQueryForResultSetMetadataOnPreparedStatement(statementSqls[selectStatementIndex]);
        try (PreparedStatement ps2 = conn.prepareStatement(sqlForMetadata);){
            ResultSetMetaData rsmd = data.getDialect().getResultSetMetadataOnPreparedStatement(ps2);
            if (rsmd == null) {
                throw new SQLException("Query does not return results");
            }
            SchemaWithInfo schemaWithInfo = new SchemaWithInfo();
            schemaWithInfo.schema = SchemaReader.metadataToSchema(data.getDialect(), rsmd, datetimenotzReadMode, dateonlyReadMode, targetSchema);
            schemaWithInfo.schemaInfo = SchemaReader.metadataToSchemaInfo(data.getType(), rsmd);
            SchemaWithInfo schemaWithInfo2 = schemaWithInfo;
            return schemaWithInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SchemaWithInfo getQuerySchemaWithInfoFromDescribeFormatted(SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String[] statementSqls, int selectStatementIndex, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        block32: {
            SchemaWithInfo schemaWithInfo = new SchemaWithInfo();
            String viewName = "schema_" + SecretKeyGenerator.generate((int)8);
            try {
                SchemaWithInfo schemaWithInfo2;
                block31: {
                    logger.info((Object)("Create a view to infer schema : " + viewName));
                    HiveConnection hiveConnection = (HiveConnection)data.getConnection();
                    Statement s = conn.createStatement();
                    try {
                        s.execute("CREATE VIEW " + viewName + " AS " + statementSqls[selectStatementIndex]);
                        String databaseName = hiveConnection.getDatabaseName();
                        TableSchema tableSchema = HiveSchemaHandler.getTableSchema(databaseName, viewName, null, conn, data.getDialect());
                        SerializedDataset ds = HiveImportabilityChecker.tableSchemaToHiveserver2Dataset(tableSchema, databaseName, viewName, datetimenotzReadMode, dateonlyReadMode);
                        schemaWithInfo.schema = ds.getSchema();
                        schemaWithInfo.schemaInfo = new SchemaInfo();
                        schemaWithInfo2 = schemaWithInfo;
                        if (s == null) break block31;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Failed to get the query schema by creating a view, falling back to limited query method", (Throwable)e);
                            break block32;
                        }
                    }
                    s.close();
                }
                return schemaWithInfo2;
            }
            finally {
                try (Statement s = conn.createStatement();){
                    s.execute("DROP VIEW IF EXISTS " + viewName);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to cleanup view created for inferring schema", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Schema getTableSchema(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) throws Exception {
        return SchemaReader.getTableSchemaWithInfo((AuthCtx)authCtx, (SQLConnectionProvider.SQLConnectionData)data, (SQLConnectionProvider.SQLConnectionWrapper)conn, (String)catalog, (String)schema, (String)table, (AbstractSQLDatasetHandler.ReadTemporalMode)datetimenotzReadMode, (AbstractSQLDatasetHandler.ReadTemporalMode)dateonlyReadMode, null).schema;
    }

    public static SchemaWithInfo getTableSchemaWithInfo(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData data, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, Schema targetSchema) throws Exception {
        try {
            if (data.getDialect().supportsDirectSchemaRetrieval()) {
                SchemaWithInfo schemaWithInfo = new SchemaWithInfo();
                schemaWithInfo.schema = data.getDialect().directRetrieveSchema(authCtx, data.getConnection(), catalog, schema, table, new SchemaOptions().withDatetimenotzReadMode(datetimenotzReadMode).withDateonlyReadMode(dateonlyReadMode));
                if (data.getDialect().supportsTablePartitionInfoRetrieval()) {
                    schemaWithInfo.tablePartitionInfo = data.getDialect().retrieveTablePartitionInfo(authCtx, data.getConnection(), catalog, schema, table);
                }
                return schemaWithInfo;
            }
            return SchemaReader.getQuerySchemaWithInfo(authCtx, data, conn, "SELECT * FROM " + data.getDialect().getQuotedTableFullName(catalog, schema, table), datetimenotzReadMode, dateonlyReadMode, targetSchema);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((String)schema) && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)"(table|object|relation).*(not found|(does not|doesn't) exist)")) {
                throw new SQLException("Table may be existing in a non-default schema", e);
            }
            throw e;
        }
    }

    public static void isSchemaCompatible(Schema in, Schema out, String inName, String outName, boolean ignoreCase) {
        if (in == null && !out.getColumns().isEmpty()) {
            throw ErrorContext.iaef((String)"Invalid number of columns, 0 in %s, %d in %s", (Object)inName, (Object[])new Object[]{out.getColumns().size(), outName});
        }
        if (in != null && out.getColumns().size() != in.getColumns().size()) {
            throw ErrorContext.iaef((String)"Invalid number of columns, %d in %s, %d in %s", (Object)in.getColumns().size(), (Object[])new Object[]{inName, out.getColumns().size(), outName});
        }
        StringBuilder errorMessage = new StringBuilder();
        for (int i = 0; i < out.getColumns().size(); ++i) {
            Type outType;
            Type inType;
            assert (in != null);
            String inColName = ((SchemaColumn)in.getColumns().get(i)).getName();
            String outColName = ((SchemaColumn)out.getColumns().get(i)).getName();
            if (!(!ignoreCase ? inColName.equals(outColName) : inColName.equalsIgnoreCase(outColName))) {
                errorMessage.append(String.format("Name mismatch for column %d : '%s' in %s, '%s' in %s%n", i + 1, inColName, inName, outColName, outName));
            }
            if ((inType = ((SchemaColumn)in.getColumns().get(i)).getType()) == (outType = ((SchemaColumn)out.getColumns().get(i)).getType())) continue;
            errorMessage.append(String.format("Type mismatch for column %d (%s) : '%s' in %s, '%s' in %s%n", i + 1, inColName, inType, inName, outType, outName));
        }
        if (!errorMessage.isEmpty()) {
            throw ErrorContext.iae((String)errorMessage.toString());
        }
    }

    public static String cleanupColumnNameForSchema(String columnName) {
        return SchemaUtils.cleanupColumnName(columnName);
    }

    private SchemaReader() {
    }

    static {
        logger = Logger.getLogger((String)"dip.input.sql");
    }

    public static class SchemaInfo {
        public boolean hasColsWithUnknownTz;
    }

    public static class SchemaWithInfo {
        public Schema schema;
        public SchemaInfo schemaInfo;
        public TablePartitionInfo tablePartitionInfo;
    }

    public static class TablePartitionInfo {
        public Dimension dimension;
    }
}

