/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.google.gson.Gson;
import java.util.Set;

public abstract class ExtractToCloudStorageOptions {
    protected Set<ExtractCompressionType> allowedCompressionTypes;
    protected ExtractDestinationFormat destinationFormat;
    public String compression;
    public Boolean printHeader;

    public String createCompression(String compression) {
        if (compression == null || compression.isEmpty()) {
            return ExtractCompressionType.NONE.toString();
        }
        try {
            ExtractCompressionType compressionEnum = ExtractCompressionType.valueOf(compression);
            if (this.allowedCompressionTypes.contains((Object)compressionEnum)) {
                return compression;
            }
            throw new RuntimeException("Unpermitted compression type: " + compression + ", for BigQuery extraction job");
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid compression type: " + compression + ", for BigQuery extraction job");
        }
    }

    public String getDestinationFormat() {
        return this.destinationFormat.toString();
    }

    public String getDestinationFormatSQL() {
        return this.destinationFormat.sqlOption;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public static enum ExtractCompressionType {
        NONE,
        GZIP,
        DEFLATE,
        SNAPPY,
        ZSTD;

    }

    public static enum ExtractDestinationFormat {
        CSV("CSV"),
        NEWLINE_DELIMITED_JSON("JSON"),
        AVRO("AVRO"),
        PARQUET("PARQUET");

        public final String sqlOption;

        private ExtractDestinationFormat(String sqlOption) {
            this.sqlOption = sqlOption;
        }
    }
}

