/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AbstractQueryBuilderWithWheres;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class UpdateQueryBuilder
extends AbstractQueryBuilderWithWheres {
    private List<String> columnsToUpdate;
    private Map<String, String> columnsToUpdateValues;

    private UpdateQueryBuilder(SQLUtils.SQLTable table) {
        super(table);
    }

    public static UpdateQueryBuilder update(SQLUtils.SQLTable table) {
        return new UpdateQueryBuilder(table);
    }

    public UpdateQueryBuilder columns(String ... columnsToUpdate) {
        this.columnsToUpdate = Arrays.asList(columnsToUpdate);
        this.columnsToUpdateValues = ImmutableMap.of();
        return this;
    }

    public UpdateQueryBuilder column(String columnToUpdate, String columnValue) {
        this.columnsToUpdate = ImmutableList.of((Object)columnToUpdate);
        this.columnsToUpdateValues = ImmutableMap.of((Object)columnToUpdate, (Object)columnValue);
        return this;
    }

    @Override
    protected void validateQuery() {
        super.validateQuery();
        Preconditions.checkState((this.columnsToUpdate != null ? 1 : 0) != 0, (Object)"No columns to update specified.");
    }

    @Override
    protected String queryStart(SQLDialect dialect) {
        return "UPDATE " + dialect.getQuotedTableFullName(this.table) + " SET " + this.buildColumnsToUpdate(dialect);
    }

    private String buildColumnsToUpdate(final SQLDialect dialect) {
        return FluentIterable.from(this.columnsToUpdate).transform((Function)new Function<String, String>(){

            public String apply(String column) {
                String updatedValue = UpdateQueryBuilder.this.columnsToUpdateValues.containsKey(column) ? dialect.quoteString(UpdateQueryBuilder.this.columnsToUpdateValues.get(column)) : "?";
                return dialect.quoteIdentifier(column) + " = (" + updatedValue + ")";
            }
        }).join(Joiner.on((String)", "));
    }
}

