/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.streaming.endpoints.StringBasedFormats;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JSONKafkaFormat {

    public static class JSONKafkaFormatSerializer
    implements KafkaFormatSerializer {
        private StringBasedFormats.JSONLineFormatSerializer serializer;
        private final JSONKafkaFormatParams params;

        public JSONKafkaFormatSerializer(JSONKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, Schema schema) {
            this.serializer = new StringBasedFormats.JSONLineFormatSerializer(cf, schema, this.params.columnNames);
        }

        @Override
        public String getKafkaSerializer() {
            return "org.apache.kafka.common.serialization.StringSerializer";
        }

        @Override
        public Object serialize(Row row) {
            return this.serializer.serialize(row);
        }

        @Override
        public List<String> columnNamesForSchema(Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(Schema schema) {
            return this.params.getSchemaColumns(schema);
        }
    }

    public static class JSONKafkaFormatDeserializer
    implements KafkaFormatDeserializer {
        private final JSONKafkaFormatParams params;
        private StringBasedFormats.JSONLineFormatDeserializer deserializer;

        public JSONKafkaFormatDeserializer(JSONKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, RowFactory rf, Schema schema) {
            this.deserializer = new StringBasedFormats.JSONLineFormatDeserializer(cf, this.params.columnNames);
        }

        @Override
        public String getKafkaDeserializer() {
            return "org.apache.kafka.common.serialization.StringDeserializer";
        }

        @Override
        public void deserialize(Object v, Row row) {
            this.deserializer.deserialize((String)v, row);
        }

        @Override
        public List<String> columnNamesForSchema(Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(Schema schema) {
            return this.params.getSchemaColumns(schema);
        }

        @Override
        public Schema fetchSchema(Properties props, String topic, boolean isKey) {
            throw new NotImplementedException("No schema fetching for json");
        }
    }

    public static class JSONKafkaFormatParams {
        public List<String> columnNames = Lists.newArrayList();

        private List<SchemaColumn> getSchemaColumns(Schema schema) {
            if (this.columnNames == null || this.columnNames.isEmpty()) {
                return Lists.newArrayList((Iterable)schema.getColumns());
            }
            ArrayList ret = Lists.newArrayList();
            for (String columnName : this.columnNames) {
                SchemaColumn sc = schema.getColumn(columnName);
                if (sc == null) continue;
                ret.add(sc);
            }
            return ret;
        }

        private List<String> columnNamesForSchema(Schema schema) {
            if (this.columnNames == null || this.columnNames.isEmpty()) {
                ArrayList ret = Lists.newArrayList();
                for (SchemaColumn sc : schema.getColumns()) {
                    ret.add(sc.getName());
                }
                return ret;
            }
            return Lists.newArrayList(this.columnNames);
        }
    }
}

