/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaSimplePuller;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class KafkaSimplePusher
implements StreamingEndpointSimplePusher {
    private final KafkaSimplePuller puller;
    private volatile boolean interrupted;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.kafka.pusher");

    public KafkaSimplePusher(AuthCtx authCtx, KafkaStreamingEndpointParams params) {
        this.puller = new KafkaSimplePuller(authCtx, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StreamingEndpointSimpleConsumer consumer, String previousState, ColumnFactory cf, RowFactory rf, Schema schema) throws Exception {
        this.puller.init(cf, rf, schema, (JsonElement)JSON.parse((String)previousState, JsonObject.class));
        try {
            while (!this.interrupted) {
                StreamingEndpointSimplePuller.RowsPulled pulled = this.puller.next();
                for (Row row : pulled.rows) {
                    consumer.onRow(row);
                }
                consumer.onNewState(JSON.json((Object)pulled.state));
            }
        }
        finally {
            this.puller.close();
        }
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        try {
            this.puller.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close puller", (Throwable)e);
        }
    }
}

