/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GlobalObjectsJGitService {
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.global.git");

    private GitLocalCommands getGlobalGit() throws IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        Git git = gitManager.getGlobalGit();
        return new GitLocalCommands(git);
    }

    public DSSGitModel.ProjectFilesLog getLogFor(String objectId, RelFile root, String since, int count) throws IOException, GitAPIException {
        String path = root.getFullPath();
        GitModel.DKULog log = this.getGlobalGit().getLog((List)Lists.newArrayList((Object[])new String[]{path}), since, count);
        DSSGitModel.ProjectFilesLog ret = new DSSGitModel.ProjectFilesLog();
        ret.logEntries = log.logEntries;
        ret.nextCommit = log.nextCommit;
        ret.objectId = objectId;
        return ret;
    }

    public DSSGitModel.ProjectFilesLog getLogFor(String objectId, RelFile root, String from, String to) throws IOException, GitAPIException {
        String path = root.getFullPath();
        GitModel.DKULog log = this.getGlobalGit().getLog(path, from, to);
        DSSGitModel.ProjectFilesLog ret = new DSSGitModel.ProjectFilesLog();
        ret.logEntries = log.logEntries;
        ret.nextCommit = log.nextCommit;
        ret.objectId = objectId;
        return ret;
    }

    public DSSGitModel.ProjectFilesDiff getDiffFor(String objectId, RelFile root, String from, String to) throws IOException, GitAPIException {
        String path = root.getFullPath();
        PathFilter tf = PathFilter.create((String)path);
        GitModel.MultiCommitDiff diff = this.getGlobalGit().diff(from, to, (TreeFilter)tf, false);
        return new DSSGitModel.ProjectFilesDiff(diff, null, objectId, path);
    }

    public GitModel.FileChange getStringDiff(String base, String target) throws IOException {
        return this.getGlobalGit().getStringDiff(base, target);
    }

    public String getHashOf(String commitId) throws IOException {
        return this.getGlobalGit().getHashOf(commitId);
    }
}

