/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.CustomWebAppHandler;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.plugins.CustomWebAppDesc;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dip.webapps.standard.AbstractStandardWebAppHandler;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CustomStandardWebAppHandler
extends AbstractStandardWebAppHandler
implements CustomWebAppHandler {
    private File directory;
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public CustomStandardWebAppHandler(WebApp webapp, File directory) {
        super(webapp);
        this.directory = directory;
    }

    @Override
    public String getBaseHref() {
        WebAppMeta meta = WebAppRegistry.getMeta(this.webapp.type);
        LoadedCustomWebApp loadedCustomWebApp = ((CustomWebAppMeta)meta).loaded;
        return String.format("/plugins/%s/%s/", loadedCustomWebApp.getOwnerPluginId(), loadedCustomWebApp.getFolderName());
    }

    @Override
    public void readCodeFiles() {
        try {
            if (!this.getHtmlFile().exists()) {
                throw new IllegalStateException("The plugin webapp has no HTML file");
            }
            if (!this.getJsFile().exists()) {
                throw new IllegalStateException("The plugin webapp has no JavaScript file");
            }
            this.params.html = FileUtils.readFileToString((File)this.getHtmlFile());
            this.params.js = FileUtils.readFileToString((File)this.getJsFile());
            if (this.getStyleFile().exists()) {
                this.params.css = FileUtils.readFileToString((File)this.getStyleFile());
            }
            if (this.getBackendFile().exists()) {
                this.params.python = FileUtils.readFileToString((File)this.getBackendFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void initWebApp() throws IOException {
        this.initApiKey(null);
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
    }

    @Override
    public void initCustomWebApp() throws IOException {
        this.initApiKey(this.getDatasetsToAuthorize());
        this.params.backendEnabled = this.getDesc().hasBackend;
        this.params.backendFramework = this.getDesc().backendFramework;
        this.params.hideJSSecurityPanel = this.getDesc().noJSSecurity;
        this.params.enableJavascriptModules = this.getDesc().enableJavascriptModules;
        List<WebAppTemplate.JavaScriptLibrary> usedJsLibraries = this.getDesc().standardWebAppLibraries;
        if (usedJsLibraries != null) {
            this.params.libraries = new HashSet<WebAppTemplate.JavaScriptLibrary>(usedJsLibraries);
        }
        this.params.hideWebAppConfig = Boolean.TRUE.equals(this.getDesc().hideWebAppConfig);
    }

    private CustomWebAppDesc getDesc() {
        return (CustomWebAppDesc)WebAppRegistry.getMeta(this.webapp.type).getWebAppDesc();
    }

    private List<String> getDatasetsToAuthorize() {
        HashSet<String> datasets = new HashSet<String>();
        try {
            if (this.getDesc().params != null) {
                for (ParamDesc p : this.getDesc().params) {
                    if (p.type != ParamDesc.Type.DATASET || !this.webapp.config.has(p.name)) continue;
                    datasets.add(this.webapp.config.get(p.name).getAsString());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read webapp config", e);
        }
        ArrayList<String> ret = new ArrayList<String>(datasets.size());
        ret.addAll(datasets);
        return ret;
    }

    @Override
    public void writeCodeFiles() throws IOException {
    }

    @Override
    public void deleteCodeFiles() throws IOException {
    }

    @Override
    public void expandVariablesForConversion() {
        this.readCodeFiles();
    }

    protected File getHtmlFile() {
        return new File(this.directory, "body.html");
    }

    protected File getStyleFile() {
        return new File(this.directory, "style.css");
    }

    protected File getJsFile() {
        return new File(this.directory, "app.js");
    }

    protected File getBackendFile() {
        return new File(this.directory, "backend.py");
    }
}

