/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.workspaces;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedWorkspacesDAO
implements WorkspacesDAO {
    public static final RelFile WORKSPACES_FOLDER = new RelFile(new String[]{"workspaces"});

    @Override
    public List<String> listWorkspaceKeys() throws IOException {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.workspaces.listKeys");){
            TransactionRef t = TransactionContext.retrieveRead();
            ArrayList<String> ret = new ArrayList<String>();
            if (t.isDirectory(WORKSPACES_FOLDER)) {
                for (RelFile workspaceFile : t.listFiles(WORKSPACES_FOLDER, (RelFileFilter)ExtensionFilter.json())) {
                    String filename = workspaceFile.getLeafName();
                    String workspaceKey = filename.substring(0, filename.length() - ".json".length());
                    ret.add(workspaceKey);
                }
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    public List<Workspace> listWorkspaces() throws IOException {
        return this.listWorkspaces(false);
    }

    @Override
    public List<Workspace> listWorkspacesUnsafe() throws IOException {
        return this.listWorkspaces(true);
    }

    @Override
    public Workspace getOrNull(String workspaceKey, boolean unsafe) throws IOException {
        RelFile f = FilesBasedWorkspacesDAO.getWorkspaceFile(workspaceKey);
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(f)) {
            return null;
        }
        Workspace workspace = unsafe ? (Workspace)t.readObjectUnsafe(f, Workspace.class) : (Workspace)t.readObject(f, Workspace.class);
        for (Workspace.WorkspaceObject object : workspace.workspaceObjects) {
            if (object.reference == null) continue;
            object.reference = new TaggableObjectsService.TaggableObjectRef(object.reference.projectKey, object.reference.type, object.reference.id, workspaceKey);
        }
        return workspace;
    }

    @Override
    public Workspace getMandatory(String workspaceKey, boolean unsafe) throws IOException {
        Workspace sp = this.getOrNull(workspaceKey, unsafe);
        if (sp == null) {
            throw new NotFoundException("Workspace does not exist: " + workspaceKey);
        }
        return sp;
    }

    @Override
    public Workspace getMandatoryUnsafe(String workspaceKey) throws IOException {
        return this.getMandatory(workspaceKey, true);
    }

    @Override
    public Workspace getMandatory(String workspaceKey) throws IOException {
        return this.getMandatory(workspaceKey, false);
    }

    @Override
    public Workspace getOrNullUnsafe(String workspaceKey) throws IOException {
        return this.getOrNull(workspaceKey, true);
    }

    @Override
    public Workspace getOrNull(String workspaceKey) throws IOException {
        return this.getOrNull(workspaceKey, false);
    }

    @Override
    public void save(Workspace workspace) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(FilesBasedWorkspacesDAO.getWorkspaceFile(workspace.workspaceKey), (Object)workspace);
    }

    private List<Workspace> listWorkspaces(boolean unsafe) throws IOException {
        ArrayList<Workspace> result = new ArrayList<Workspace>();
        for (String workspaceKey : this.listWorkspaceKeys()) {
            Workspace workspace = this.getOrNull(workspaceKey, unsafe);
            if (workspace == null) continue;
            result.add(workspace);
        }
        return result;
    }

    @Override
    public void delete(String workspaceKey) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(FilesBasedWorkspacesDAO.getWorkspaceFile(workspaceKey));
    }

    @Override
    public boolean exists(String workspaceKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.exists(FilesBasedWorkspacesDAO.getWorkspaceFile(workspaceKey));
    }

    private static RelFile getWorkspaceFile(String workspaceKey) {
        return new RelFile(WORKSPACES_FOLDER, new String[]{workspaceKey + ".json"});
    }
}

