/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class AsDatetimeNoTz
implements Function {
    DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    private LocalDateTime parseDate(String date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC);
            return formatter.parseLocalDateTime(date);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        String strDate;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least an argument");
        }
        if (args[0] instanceof LocalDateTime) {
            return args[0];
        }
        if (args[0] instanceof LocalDate) {
            return ((LocalDate)args[0]).toLocalDateTime(LocalTime.MIDNIGHT);
        }
        if (args[0] instanceof DateTime) {
            return ((DateTime)args[0]).toLocalDateTime();
        }
        if (args[0] instanceof Calendar) {
            return new LocalDateTime((Object)((Calendar)args[0]).getTime(), DateTimeZone.UTC);
        }
        if (args[0] instanceof Date) {
            return new LocalDateTime(((Date)args[0]).getTime(), DateTimeZone.UTC);
        }
        if (args[0] instanceof Long) {
            strDate = ((Long)args[0]).toString();
        } else if (args[0] instanceof String) {
            strDate = (String)args[0];
            if (strDate.isEmpty()) {
                return new EvalError("Empty string (in " + GrelControlFunctionRegistry.getInstance().getFunctionName(this) + ")");
            }
        } else {
            return new EvalError("Not a String - cannot parse to datetime no tz");
        }
        if (args.length >= 2) {
            for (int i = 1; i < args.length; ++i) {
                LocalDateTime date;
                if (!(args[i] instanceof String) || (date = this.parseDate(strDate, (String)args[i])) == null) continue;
                return date;
            }
        } else {
            LocalDateTime date;
            try {
                date = this.formulaUtils.asDatetimeNoTz(strDate, bindings);
            }
            catch (Exception e) {
                try {
                    date = this.formulaUtils.asDate(strDate, bindings).toLocalDateTime();
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            if (date != null) {
                return date;
            }
        }
        return new EvalError("Unable to parse as datetime no tz: " + String.valueOf(args[0]));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.AsDateTimeNoTz.DOCUMENTATION", "Returns <code>o</code> converted to <code>datetime no tz</code>. If you don't give a format, <code>\"yyyy-MM-dd HH:mm:ss\"</code> is used. You can give an ordered list of possible formats using this syntax: <a href=\"https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html\" target=\"dss_formula\">SimpleDateFormat</a>. The <code>format</code> arguments are ignored when using the SQL engine.").withParams("o, [format1 ...]").withReturns("datetime no tz").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("\"2020-04-02 22\"", "\"yyyy-MM-dd HH\"").returns("2020-04-02 22:00:00.000"));
    }
}

