/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.dataiku.dip.shaker.DateTimeFormatterFix;
import com.dataiku.dss.shadelib.com.google.common.base.Optional;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class ToString
implements Function {
    @Override
    public String call(Properties bindings, Object[] args) {
        ToStringFormatter formatter;
        if (args.length == 0) {
            return null;
        }
        Object o1 = args[0];
        if (o1 == null) {
            return null;
        }
        if (o1 instanceof Date) {
            Date date = (Date)o1;
            formatter = new DateToStringFormatter(date);
        } else if (o1 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)o1;
            formatter = new LocalDateToStringFormatter(localDate);
        } else if (o1 instanceof Calendar) {
            Calendar calendar = (Calendar)o1;
            formatter = new DateToStringFormatter(calendar.getTime());
        } else if (o1 instanceof DateTime) {
            DateTime dateTime = (DateTime)o1;
            formatter = new DateTimeToStringFormatter(dateTime);
        } else if (o1 instanceof LocalDateTime) {
            LocalDateTime locaDateTime = (LocalDateTime)o1;
            formatter = new LocalDateTimeToStringFormatter(locaDateTime);
        } else {
            formatter = new OtherToStringFormatter(o1);
        }
        return formatter.format(args);
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ToString.DOCUMENTATION", "Returns <code>o</code> converted to a string.").withParams("o, [string format]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("5").returns("\"5\""));
    }

    private static class DateToStringFormatter
    extends ToStringFormatter {
        private final Date dateToFormat;

        private DateToStringFormatter(Date dateToFormat) {
            this.dateToFormat = dateToFormat;
        }

        @Override
        protected String formatWithDefaultPattern() {
            return DateFormat.getDateInstance().format(this.dateToFormat);
        }

        @Override
        protected String formatWithPattern(String pattern) {
            return new SimpleDateFormat(pattern).format(this.dateToFormat);
        }
    }

    private static class LocalDateToStringFormatter
    extends ToStringFormatter {
        private final LocalDate dateToFormat;

        private LocalDateToStringFormatter(LocalDate dateToFormat) {
            this.dateToFormat = dateToFormat;
        }

        @Override
        protected String formatWithDefaultPattern() {
            return this.dateToFormat.toString();
        }

        @Override
        protected String formatWithPattern(String pattern) {
            return this.dateToFormat.toString(DateTimeFormat.forPattern((String)pattern));
        }
    }

    private static class DateTimeToStringFormatter
    extends ToStringFormatter {
        private final DateTime dateTimeToFormat;

        private DateTimeToStringFormatter(DateTime dateTimeToFormat) {
            this.dateTimeToFormat = dateTimeToFormat;
        }

        @Override
        protected String formatWithDefaultPattern() {
            return this.dateTimeToFormat.toString((DateTimeFormatter)null);
        }

        @Override
        protected String formatWithPattern(String pattern) {
            return DateTimeFormatterFix.forPattern(pattern).print((ReadableInstant)this.dateTimeToFormat);
        }
    }

    private static class LocalDateTimeToStringFormatter
    extends ToStringFormatter {
        private final LocalDateTime dateTimeToFormat;

        private LocalDateTimeToStringFormatter(LocalDateTime dateTimeToFormat) {
            this.dateTimeToFormat = dateTimeToFormat;
        }

        @Override
        protected String formatWithDefaultPattern() {
            return this.dateTimeToFormat.toString();
        }

        @Override
        protected String formatWithPattern(String pattern) {
            return this.dateTimeToFormat.toString(DateTimeFormat.forPattern((String)pattern));
        }
    }

    private static class OtherToStringFormatter
    extends ToStringFormatter {
        private final Object objectToFormat;

        private OtherToStringFormatter(Object objectToFormat) {
            this.objectToFormat = objectToFormat;
        }

        @Override
        protected String formatWithDefaultPattern() {
            return this.objectToFormat.toString();
        }

        @Override
        protected String formatWithPattern(String pattern) {
            return this.objectToFormat.toString();
        }
    }

    private static abstract class ToStringFormatter {
        private ToStringFormatter() {
        }

        protected abstract String formatWithDefaultPattern();

        protected abstract String formatWithPattern(String var1);

        String format(Object[] args) {
            Optional<String> pattern = this.getPattern(args);
            if (pattern.isPresent()) {
                return this.formatWithPattern((String)pattern.get());
            }
            return this.formatWithDefaultPattern();
        }

        private Optional<String> getPattern(Object[] args) {
            if (args.length == 2) {
                Object o2 = args[1];
                if (o2 instanceof String) {
                    return Optional.of((Object)((String)o2));
                }
                if (o2 instanceof Number) {
                    return Optional.absent();
                }
                throw new IllegalArgumentException(String.format("Invalid format %s. Expecting a string but got: %s", o2, o2.getClass().getSimpleName()));
            }
            return Optional.absent();
        }
    }
}

