/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class GeoSimplify
implements Function {
    private static final GeometryMeaning geometryMeaning = new GeometryMeaning();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object geometry = args[0];
            Object toleranceDistance = args[1];
            if (geometry instanceof String && !StringUtils.isBlank((String)((String)geometry))) {
                if (toleranceDistance != null) {
                    if (!(toleranceDistance instanceof Number)) {
                        return new EvalError("Cannot parse to double: toleranceDistance");
                    }
                    double tolerance = ((Number)toleranceDistance).doubleValue();
                    if (tolerance >= 0.0) {
                        Geometry parsedGeometry = geometryMeaning.toGeometry((String)geometry);
                        if (parsedGeometry != null) {
                            Geometry simplifiedGeometry = TopologyPreservingSimplifier.simplify((Geometry)parsedGeometry, (double)tolerance);
                            if (simplifiedGeometry != null && simplifiedGeometry.isValid()) {
                                return simplifiedGeometry.toString();
                            }
                            return parsedGeometry.toString();
                        }
                        return new EvalError("geometry parameter doesn't contain geospatial data");
                    }
                }
                return new EvalError("toleranceDistance parameter expects a non-negative number");
            }
            return null;
        }
        return new EvalError(String.format("%s requires two arguments)", GrelControlFunctionRegistry.getInstance().getFunctionName(this)));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoSimplify.DOCUMENTATION", "Simplifies geometry coordinates using a toleranceDistance for the simplification. All vertices in the simplified geometry will be within this distance of the original geometry. The toleranceDistance value must be non-negative. A tolerance value of zero is a no-op.").withParams("string geometry, double toleranceDistance").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withExample(Example.with("\"LINESTRING(1 1, 3 1, 2 1)\"", "1.0").returns("LINESTRING (1 1, 2 1)")).withExample(Example.with("geometryColumn", "2.0").returns("a column of simplified geometries where 'geometryColumn' is a column name from the dataset")).withExample(Example.with("geometryColumn", "distanceColumn").returns("a column of simplified geometries where 'distanceColumn' is a column name from the dataset"));
    }
}

