/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

public class Scanner {
    protected String _text;
    protected int _index;
    protected int _limit;

    public Scanner(String s) {
        this(s, 0, s.length());
    }

    public Scanner(String s, int from, int to) {
        this._text = s;
        this._index = from;
        this._limit = to;
    }

    public int getIndex() {
        return this._index;
    }

    public Token next(boolean regexPossible) {
        while (this._index < this._limit && Character.isWhitespace(this._text.charAt(this._index))) {
            ++this._index;
        }
        if (this._index == this._limit) {
            return null;
        }
        char c2 = this._text.charAt(this._index);
        int start = this._index++;
        String detail = null;
        if (Character.isDigit(c2)) {
            long value = 0L;
            while (this._index < this._limit && Character.isDigit(c2 = this._text.charAt(this._index))) {
                value = value * 10L + (long)(c2 - 48);
                ++this._index;
            }
            if (this._index < this._limit && c2 == '.') {
                double value2 = value;
                if (c2 == '.') {
                    ++this._index;
                    double division = 1.0;
                    while (this._index < this._limit && Character.isDigit(c2 = this._text.charAt(this._index))) {
                        value2 = value2 * 10.0 + (double)(c2 - 48);
                        division *= 10.0;
                        ++this._index;
                    }
                    value2 /= division;
                }
                return new NumberToken(start, this._index, this._text.substring(start, this._index), value2);
            }
            if (Character.isLetter(c2) || c2 == '_') {
                char c1;
                while (this._index < this._limit && ((c1 = this._text.charAt(this._index)) == '_' || Character.isLetterOrDigit(c1))) {
                    ++this._index;
                }
                return new Token(start, this._index, TokenType.Identifier, this._text.substring(start, this._index));
            }
            return new NumberToken(start, this._index, this._text.substring(start, this._index), value);
        }
        if (c2 == '\"' || c2 == '\'') {
            StringBuffer sb = new StringBuffer();
            char delimiter = c2;
            ++this._index;
            while (this._index < this._limit) {
                c2 = this._text.charAt(this._index);
                if (c2 == delimiter) {
                    ++this._index;
                    return new Token(start, this._index, TokenType.String, sb.toString());
                }
                if (c2 == '\\') {
                    ++this._index;
                    if (this._index < this._limit) {
                        char c22 = this._text.charAt(this._index);
                        if (c22 == 't') {
                            sb.append('\t');
                        } else if (c22 == 'n') {
                            sb.append('\n');
                        } else if (c22 == 'r') {
                            sb.append('\r');
                        } else if (c22 == '\\') {
                            sb.append('\\');
                        } else {
                            sb.append(c22);
                        }
                    }
                } else {
                    sb.append(c2);
                }
                ++this._index;
            }
            detail = "String not properly closed";
        } else {
            if (Character.isLetter(c2) || c2 == '_') {
                char c1;
                while (this._index < this._limit && ((c1 = this._text.charAt(this._index)) == '_' || Character.isLetterOrDigit(c1))) {
                    ++this._index;
                }
                return new Token(start, this._index, TokenType.Identifier, this._text.substring(start, this._index));
            }
            if (c2 == '/' && regexPossible) {
                StringBuffer sb = new StringBuffer();
                while (this._index < this._limit) {
                    c2 = this._text.charAt(this._index);
                    if (c2 == '/') {
                        ++this._index;
                        boolean caseInsensitive = false;
                        if (this._index < this._limit && this._text.charAt(this._index) == 'i') {
                            caseInsensitive = true;
                            ++this._index;
                        }
                        return new RegexToken(start, this._index, sb.toString(), caseInsensitive);
                    }
                    if (c2 == '\\') {
                        sb.append(c2);
                        ++this._index;
                        if (this._index < this._limit) {
                            sb.append(this._text.charAt(this._index));
                        }
                    } else {
                        sb.append(c2);
                    }
                    ++this._index;
                }
                detail = "Regex not properly closed";
            } else {
                if ("+-*.%".indexOf(c2) >= 0) {
                    ++this._index;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '/') {
                    if (this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '/') {
                        ++this._index;
                    }
                    ++this._index;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if ("()[],".indexOf(c2) >= 0) {
                    ++this._index;
                    return new Token(start, this._index, TokenType.Delimiter, this._text.substring(start, this._index));
                }
                if (c2 == '!' && this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '=') {
                    this._index += 2;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '&' && this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '&') {
                    this._index += 2;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '|' && this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '|') {
                    this._index += 2;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '!') {
                    ++this._index;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '=' && this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '=') {
                    this._index += 2;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                if (c2 == '<' || c2 == '>') {
                    this._index = this._index < this._limit - 1 && this._text.charAt(this._index + 1) == '=' ? (this._index += 2) : ++this._index;
                    return new Token(start, this._index, TokenType.Operator, this._text.substring(start, this._index));
                }
                ++this._index;
                detail = "Unrecognized symbol";
            }
        }
        return new ErrorToken(start, this._index, this._text.substring(start, this._index), detail);
    }

    public static class NumberToken
    extends Token {
        public final Number value;

        public NumberToken(int start, int end, String text, Number value) {
            super(start, end, TokenType.Number, text);
            this.value = value;
        }
    }

    public static class Token {
        public final int start;
        public final int end;
        public final TokenType type;
        public final String text;

        Token(int start, int end, TokenType type, String text) {
            this.start = start;
            this.end = end;
            this.type = type;
            this.text = text;
        }
    }

    public static enum TokenType {
        Error,
        Delimiter,
        Operator,
        Identifier,
        Number,
        String,
        Regex;

    }

    public static class RegexToken
    extends Token {
        public final boolean caseInsensitive;

        public RegexToken(int start, int end, String text, boolean caseInsensitive) {
            super(start, end, TokenType.Regex, text);
            this.caseInsensitive = caseInsensitive;
        }
    }

    public static class ErrorToken
    extends Token {
        public final String detail;

        public ErrorToken(int start, int end, String text, String detail) {
            super(start, end, TokenType.Error, text);
            this.detail = detail;
        }
    }
}

