/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public final class Type
extends Enum<Type> {
    public static final /* enum */ Type STRING = new Type("string");
    public static final /* enum */ Type DATE = new Type("date", new String[]{"datetimetz"});
    public static final /* enum */ Type DATETIMENOTZ = new Type("datetimenotz", DATE);
    public static final /* enum */ Type DATEONLY = new Type("dateonly", DATETIMENOTZ);
    public static final /* enum */ Type GEOPOINT = new Type("geopoint");
    public static final /* enum */ Type GEOMETRY = new Type("geometry");
    public static final /* enum */ Type ARRAY = new Type("array");
    public static final /* enum */ Type MAP = new Type("map");
    public static final /* enum */ Type OBJECT = new Type("object");
    public static final /* enum */ Type DOUBLE = new Type("double");
    public static final /* enum */ Type BOOLEAN = new Type("boolean");
    public static final /* enum */ Type FLOAT = new Type("float", DOUBLE);
    public static final /* enum */ Type BIGINT = new Type("bigint");
    public static final /* enum */ Type INT = new Type("int", BIGINT);
    public static final /* enum */ Type SMALLINT = new Type("smallint", INT);
    public static final /* enum */ Type TINYINT = new Type("tinyint", SMALLINT);
    private final String name;
    private final String[] aliases;
    private Type superType;
    private static final /* synthetic */ Type[] $VALUES;

    public static Type[] values() {
        return (Type[])$VALUES.clone();
    }

    public static Type valueOf(String name) {
        return Enum.valueOf(Type.class, name);
    }

    private Type(String name) {
        this.name = name;
        this.aliases = null;
    }

    private Type(String name, String[] aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    private Type(String name, Type superType) {
        this.name = name;
        this.aliases = null;
        this.superType = superType;
    }

    private Type(String name, String[] aliases, Type superType) {
        this.name = name;
        this.aliases = aliases;
        this.superType = superType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        switch (this) {
            case ARRAY: 
            case MAP: 
            case OBJECT: {
                return false;
            }
        }
        return true;
    }

    public boolean isNumeric() {
        return this.isInteger() || this.isFloatingPoint();
    }

    public boolean isGeo() {
        switch (this) {
            case GEOPOINT: 
            case GEOMETRY: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatingPoint() {
        switch (this) {
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        switch (this) {
            case BIGINT: 
            case INT: 
            case TINYINT: 
            case SMALLINT: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumericOrBoolean() {
        return this.isNumeric() || this == BOOLEAN;
    }

    public boolean isTemporal() {
        switch (this) {
            case DATE: 
            case DATEONLY: 
            case DATETIMENOTZ: {
                return true;
            }
        }
        return false;
    }

    public boolean isTimestamp() {
        switch (this) {
            case DATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatibleWith(Type other) {
        return this.isGeo() && other.isGeo() || this.equals((Object)other);
    }

    public boolean isComparable() {
        if (this.isNumeric()) {
            return true;
        }
        return this.isTemporal();
    }

    public static Type forName(String name) {
        for (Type t : Type.values()) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        for (Type t : Type.values()) {
            if (t.aliases == null || t.aliases.length <= 0) continue;
            for (String a : t.aliases) {
                if (!a.equals(name)) continue;
                return t;
            }
        }
        throw ErrorContext.iae((String)("Type not found: " + name));
    }

    public static boolean exists(String name) {
        for (Type t : Type.values()) {
            if (!t.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private List<Type> ancestors() {
        ArrayList<Type> ancestors = new ArrayList<Type>();
        ancestors.add(this);
        Type ancestor = this.superType;
        int i = 0;
        while (ancestor != null) {
            assert (i++ < Type.values().length);
            ancestors.add(0, ancestor);
            ancestor = ancestor.superType;
        }
        return ancestors;
    }

    public Type commonSuperType(Type other) {
        if (this == other) {
            return this;
        }
        List<Type> myAncestors = this.ancestors();
        List<Type> itsAncestors = other.ancestors();
        Type common_ancestor = null;
        for (int i = 0; i < myAncestors.size() && i < itsAncestors.size() && myAncestors.get(i) == itsAncestors.get(i); ++i) {
            common_ancestor = myAncestors.get(i);
        }
        return common_ancestor;
    }

    private static /* synthetic */ Type[] $values() {
        return new Type[]{STRING, DATE, DATETIMENOTZ, DATEONLY, GEOPOINT, GEOMETRY, ARRAY, MAP, OBJECT, DOUBLE, BOOLEAN, FLOAT, BIGINT, INT, SMALLINT, TINYINT};
    }

    static {
        $VALUES = Type.$values();
    }
}

