/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.clustering;

import com.dataiku.dip.spark.ml.clustering.ClusteringStatistics;
import com.dataiku.dip.utils.DKULogger;
import java.io.Serializable;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IterableViewLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ClusteringStatistics$ {
    public static ClusteringStatistics$ MODULE$;
    private final long MaxSampled;
    private final int nBins;
    private final DKULogger com$dataiku$dip$spark$ml$clustering$ClusteringStatistics$$logger;

    static {
        new ClusteringStatistics$();
    }

    public long MaxSampled() {
        return this.MaxSampled;
    }

    public int nBins() {
        return this.nBins;
    }

    public <T> scala.collection.immutable.IndexedSeq<T> sampleFrom(RDD<T> rdd, long seed, long maxSampled) {
        long n = rdd.count();
        if (n <= this.MaxSampled()) {
            return Predef$.MODULE$.genericArrayOps(rdd.collect()).toIndexedSeq();
        }
        double frac = (double)this.MaxSampled() / (double)n;
        return Predef$.MODULE$.genericArrayOps(rdd.sample(false, frac, seed).collect()).toIndexedSeq();
    }

    public <T> long sampleFrom$default$3() {
        return this.MaxSampled();
    }

    public double squareDistance(Vector v1, Vector v2) {
        Predef$.MODULE$.require(v1.size() == v2.size());
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableViewLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), v1.size()).view().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> v1.apply(i) - v2.apply(i), SeqView$.MODULE$.canBuildFrom())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)u -> u * u, SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double com$dataiku$dip$spark$ml$clustering$ClusteringStatistics$$pointwiseSilhouette(ClusteringStatistics.StatisticsAggregator[][] agg, int cluster, IndexedSeq<Object> x) {
        Seq meanDistances = (Seq)((IterableViewLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])agg)).view().map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)ClusteringStatistics$.$anonfun$pointwiseSilhouette$1(x, v)), IndexedSeqView$.MODULE$.arrCanBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom());
        double a = ((Tuple2)meanDistances.apply(cluster))._1$mcD$sp();
        double b = ((Tuple2)((TraversableOnce)meanDistances.filter((Function1 & Serializable & scala.Serializable)x$65 -> BoxesRunTime.boxToBoolean((boolean)ClusteringStatistics$.$anonfun$pointwiseSilhouette$3(cluster, x$65)))).minBy((Function1 & Serializable & scala.Serializable)x$66 -> BoxesRunTime.boxToDouble((double)x$66._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))._1$mcD$sp();
        return (b - a) / package$.MODULE$.max(a, b);
    }

    public DKULogger com$dataiku$dip$spark$ml$clustering$ClusteringStatistics$$logger() {
        return this.com$dataiku$dip$spark$ml$clustering$ClusteringStatistics$$logger;
    }

    public static final /* synthetic */ double $anonfun$pointwiseSilhouette$1(IndexedSeq x$67, ClusteringStatistics.StatisticsAggregator[] v) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)x$67.indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)x$67.apply(i)) * BoxesRunTime.unboxToDouble((Object)x$67.apply(i)) + v[i].sumOfSquares() / (double)v[i].count() - (double)2 * BoxesRunTime.unboxToDouble((Object)x$67.apply(i)) * (double)v[i].count() / (double)v[i].count(), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$pointwiseSilhouette$3(int cluster$1, Tuple2 x$65) {
        return x$65._2$mcI$sp() != cluster$1;
    }

    private ClusteringStatistics$() {
        MODULE$ = this;
        this.MaxSampled = 1000000L;
        this.nBins = 60;
        this.com$dataiku$dip$spark$ml$clustering$ClusteringStatistics$$logger = DKULogger.getLogger((String)"dku.ml.clustering.statistics");
    }
}

