/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ExportToS3TaskSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    @Override
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        SdkInternalList createInstanceExportTaskRequestTagSpecificationsList;
        ExportToS3TaskSpecification exportToS3Task;
        if (createInstanceExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInstanceExportTaskRequest> request = new DefaultRequest<CreateInstanceExportTaskRequest>(createInstanceExportTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceExportTaskRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createInstanceExportTaskRequest.getDescription()));
        }
        if ((exportToS3Task = createInstanceExportTaskRequest.getExportToS3Task()) != null) {
            if (exportToS3Task.getContainerFormat() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString(exportToS3Task.getContainerFormat()));
            }
            if (exportToS3Task.getDiskImageFormat() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString(exportToS3Task.getDiskImageFormat()));
            }
            if (exportToS3Task.getS3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString(exportToS3Task.getS3Bucket()));
            }
            if (exportToS3Task.getS3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString(exportToS3Task.getS3Prefix()));
            }
        }
        if (createInstanceExportTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createInstanceExportTaskRequest.getInstanceId()));
        }
        if (createInstanceExportTaskRequest.getTargetEnvironment() != null) {
            request.addParameter("TargetEnvironment", StringUtils.fromString(createInstanceExportTaskRequest.getTargetEnvironment()));
        }
        if (!(createInstanceExportTaskRequestTagSpecificationsList = (SdkInternalList)createInstanceExportTaskRequest.getTagSpecifications()).isEmpty() || !createInstanceExportTaskRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createInstanceExportTaskRequestTagSpecificationsListValue : createInstanceExportTaskRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createInstanceExportTaskRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createInstanceExportTaskRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createInstanceExportTaskRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

