/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class RegisterTargetsRequestMarshaller
implements Marshaller<Request<RegisterTargetsRequest>, RegisterTargetsRequest> {
    @Override
    public Request<RegisterTargetsRequest> marshall(RegisterTargetsRequest registerTargetsRequest) {
        if (registerTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterTargetsRequest> request = new DefaultRequest<RegisterTargetsRequest>(registerTargetsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RegisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerTargetsRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString(registerTargetsRequest.getTargetGroupArn()));
        }
        if (registerTargetsRequest.getTargets() != null) {
            List<TargetDescription> targetsList = registerTargetsRequest.getTargets();
            if (targetsList.isEmpty()) {
                request.addParameter("Targets", "");
            } else {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue != null) {
                        if (targetsListValue.getId() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString(targetsListValue.getId()));
                        }
                        if (targetsListValue.getPort() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger(targetsListValue.getPort()));
                        }
                        if (targetsListValue.getAvailabilityZone() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringUtils.fromString(targetsListValue.getAvailabilityZone()));
                        }
                    }
                    ++targetsListIndex;
                }
            }
        }
        return request;
    }
}

