/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.ServiceDiscoveryMode;
import com.databricks.client.hivecommon.api.HS2Client;
import com.databricks.client.hivecommon.api.HiveServer2ClientFactory;
import com.databricks.client.hivecommon.api.IHiveClient;
import com.databricks.client.hivecommon.core.CoreUtils;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransport;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class ServiceDiscoveryFactory
extends HiveServer2ClientFactory {
    protected static final String HOST_PORT_SEPARATOR = ":";
    protected ErrorException m_cacheExp;

    @Override
    public IHiveClient<?> createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, iLogger, iWarningListener);
        TTransport tTransport = null;
        try {
            if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == hiveJDBCSettings.m_serviceDiscoveryMode) {
                tTransport = ServiceDiscoveryFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
            } else if (null == (tTransport = this.createTransportFromServers(hiveJDBCSettings, tTransport, iLogger, iWarningListener))) {
                this.throwUnableToDiscoverServersError(hiveJDBCSettings.m_serviceDiscoveryMode);
            }
            return new HS2Client(hiveJDBCSettings, new TBinaryProtocol(tTransport), iLogger, iWarningListener);
        }
        catch (ErrorException errorException) {
            if (tTransport != null) {
                tTransport.close();
            }
            throw errorException;
        }
    }

    @Override
    public abstract boolean supportServiceDiscoveryMode(ServiceDiscoveryMode var1, ILogger var2);

    protected TTransport createTransportFromServers(HiveJDBCSettings hiveJDBCSettings, TTransport tTransport, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        Object object;
        block8: {
            LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, tTransport, iLogger, iWarningListener);
            String string = null;
            do {
                try {
                    string = this.getNextServer(hiveJDBCSettings, iLogger);
                    if (null != string) {
                        object = string.split(HOST_PORT_SEPARATOR);
                        hiveJDBCSettings.m_host = object[0];
                        hiveJDBCSettings.m_port = Integer.parseInt(object[1]);
                        if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech && hiveJDBCSettings.m_krbHostFQDN.equals("_HOST")) {
                            hiveJDBCSettings.m_krbHostFQDN = hiveJDBCSettings.m_host;
                        }
                        LogUtilities.logInfo("Trying to connect to : " + hiveJDBCSettings.m_host + " on port: " + hiveJDBCSettings.m_port, iLogger);
                        tTransport = ServiceDiscoveryFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
                        continue;
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (exception instanceof ErrorException) {
                        ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_CONNECTION_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), string, exception.getMessage()});
                    errorException.initCause(exception);
                    this.m_cacheExp = errorException;
                    LogUtilities.logDebug("Unable to connect to server : " + string, iLogger);
                    this.logExceptionAndPostWarning(errorException, iLogger, iWarningListener, hiveJDBCSettings.m_suppressWarningsAsDebugLog);
                }
            } while (null == tTransport);
            LogUtilities.logDebug("Connected to server: " + string, iLogger);
        }
        if (hiveJDBCSettings.m_zookeeperSettings.m_zkTestingEnabled) {
            if (tTransport != null || this.m_cacheExp == null) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ZOOKEEPER_EMULATION_ERROR.name(), new String[]{hiveJDBCSettings.m_host, String.valueOf(hiveJDBCSettings.m_port)});
                throw object;
            }
            throw this.m_cacheExp;
        }
        return tTransport;
    }

    protected abstract String getNextServer(HiveJDBCSettings var1, ILogger var2);

    protected void logExceptionAndPostWarning(ErrorException errorException, ILogger iLogger, IWarningListener iWarningListener, boolean bl) {
        LogUtilities.logFunctionEntrance(iLogger, errorException, iLogger, iWarningListener);
        CoreUtils.postWarning(errorException, iWarningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage(), iLogger, bl);
        HiveJDBCExceptionUtils.logException(errorException, iLogger);
    }

    protected void throwUnableToDiscoverServersError(ServiceDiscoveryMode serviceDiscoveryMode) throws ErrorException {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_NO_SERVERS.name(), new String[]{String.valueOf((Object)serviceDiscoveryMode)});
        if (null != this.m_cacheExp) {
            this.m_cacheExp.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            errorException.initCause(this.m_cacheExp);
        }
        throw errorException;
    }
}

