/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc42;

import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.interfaces.IResults;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResultType;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SForwardResultSet;
import com.databricks.client.jdbc.common.SPreparedStatement;
import com.databricks.client.jdbc.common.SResultSetMetaData;
import com.databricks.client.jdbc.common.SStatement;
import com.databricks.client.jdbc.jdbc41.S41PreparedStatement;
import com.databricks.client.jdbc.jdbc42.S42ForwardResultSet;
import com.databricks.client.jdbc.jdbc42.S42ParameterMetaData;
import com.databricks.client.jdbc.jdbc42.S42ResultSetMetaData;
import com.databricks.client.jdbc.jdbc42.S42UpdatableForwardResultSet;
import com.databricks.client.jdbc.jdbc42.utilities.CustomSqlTypes;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Iterator;
import java.util.List;

public class S42PreparedStatement
extends S41PreparedStatement {
    private long m_longTotal = Long.MAX_VALUE;

    public S42PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S42UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S42ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults iResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> iterator = iResults.getResultItr();
                if (!iterator.hasNext()) {
                    return null;
                }
                ExecutionResult executionResult = iterator.next();
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(iResultSet));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet iResultSet) throws SQLException {
        try {
            List list = iResultSet.getSelectColumns();
            if (null == list) {
                return null;
            }
            return new S42ResultSetMetaData(list, this.getLogger(), this.getWarningListener());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S42ParameterMetaData s42ParameterMetaData = null;
                s42ParameterMetaData = new S42ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s42ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        if (!(sQLType instanceof JDBCType) && !(sQLType instanceof CustomSqlTypes)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n2 = sQLType.getVendorTypeNumber();
        this.setObject(n, object, n2);
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, object, sQLType, n2);
        if (!(sQLType instanceof JDBCType) && !(sQLType instanceof CustomSqlTypes)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n3 = sQLType.getVendorTypeNumber();
        this.setObject(n, object, n3, n2);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            SPreparedStatement.BatchExecResult batchExecResult = this.executePreparedAnyBatch();
            switch (batchExecResult) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new long[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processLargeBatchResults(this.m_queryExecutor.getResults(), this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
                case BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION: {
                    return this.processLargeBatchResults(null, this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + batchExecResult.name());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(2).getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }
}

