# encoding: utf-8
"""
Executor for containerized execution of python scoring recipe.
"""

import json
import logging

from dataiku.base.folder_context import build_folder_context
from dataiku.base.utils import ErrorMonitoringWrapper
from .runner import setup_log, read_execution

if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']
    execution_dir_folder_context = build_folder_context(execution["executionPath"])

    with ErrorMonitoringWrapper():
        logging.info("Launching doctor main")
        if execution['type'] == 'RECIPE_PREDICTION_SCORE_PYTHON':
            from dataiku.doctor.prediction.reg_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(
                execution["contextPath"],
                names['inputDatasetSmartName'],
                names['managedFolderSmartId'],
                names['outputDatasetSmartName'],
                execution_dir_folder_context.read_json('desc.json'),
                execution_dir_folder_context.read_json('script.json'),
                execution_dir_folder_context.read_json('preparation_output_schema.json'),
                execution_dir_folder_context.read_json('conditional_outputs.json'),
                names['inputModel']
            )
        elif execution['type'] == 'RECIPE_PREDICTION_SCORE_KERAS':
            from dataiku.doctor.prediction.keras_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(execution["contextPath"], names['inputDatasetSmartName'], names['outputDatasetSmartName'],
                execution_dir_folder_context.read_json('desc.json'),
                execution_dir_folder_context.read_json('script.json'),
                execution_dir_folder_context.read_json('preparation_output_schema.json'),
                execution_dir_folder_context.read_json('conditional_outputs.json'),
                names['inputModel']
            )
        elif execution['type'] == 'RECIPE_PREDICTION_SCORE_DEEPHUB':
            from dataiku.doctor.deephub.launch_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(execution["contextPath"], names['inputDatasetSmartName'], names['managedFolderSmartId'], names['outputDatasetSmartName'],
                 execution_dir_folder_context.read_json('desc.json'),
                 execution_dir_folder_context.read_json('script.json'),
                 execution_dir_folder_context.read_json('preparation_output_schema.json'),
                 names['inputModel']
                 )
        elif execution['type'] == 'RECIPE_PREDICTION_SCORE_TIMESERIES':
            from dataiku.doctor.timeseries.score.launch_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(execution["contextPath"], names['inputDatasetSmartName'], names['outputDatasetSmartName'],
                 execution_dir_folder_context.read_json('desc.json'),
                 execution_dir_folder_context.read_json('script.json'),
                 execution_dir_folder_context.read_json('preparation_output_schema.json'),
                 names['inputModel'], execution["executionPath"])

        elif execution['type'] == 'RECIPE_PREDICTION_SCORE_CAUSAL':
            from dataiku.doctor.causal.score.launch_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(execution["contextPath"], names['inputDatasetSmartName'], names['outputDatasetSmartName'],
                 execution_dir_folder_context.read_json('desc.json'),
                 execution_dir_folder_context.read_json('script.json'),
                 execution_dir_folder_context.read_json('preparation_output_schema.json'),
                 names['inputModel'])
        elif execution['type'] == 'RECIPE_PREDICTION_SCORE_MLFLOW':
            from dataiku.external_ml.mlflow.pyfunc_scoring_recipe import main
            names = json.loads(execution['payload'])
            recipe_desc = execution_dir_folder_context.read_json('desc.json')
            fmi = names['inputModel'] if recipe_desc.get("outputModelMetadata") else ""
            main(execution["contextPath"], names['inputDatasetSmartName'], names['outputDatasetSmartName'], names['outputStyle'],
                 names['forcedClassifierThreshold'], recipe_desc, fmi)
        elif execution['type'] == 'RECIPE_CLUSTERING_SCORE_PYTHON':
            from dataiku.doctor.clustering.reg_scoring_recipe import main
            names = json.loads(execution['payload'])
            main(execution["contextPath"], names['inputDatasetSmartName'], names['outputDatasetSmartName'],
                execution_dir_folder_context.read_json('desc.json'),
                execution_dir_folder_context.read_json('script.json'),
                execution_dir_folder_context.read_json('preparation_output_schema.json'),
                names['inputModel']
            )
        else:
            raise Exception("Unsupported scoring recipe type: %s" % execution['type'])

