(function () {
    "use strict";

    const featuresCount = {
        bindings: {
            recipeStatus: '<',
            recipeStateUpdateInProgress: "<",
            virtualInputs: '<',
            inputs: '<',
            computablesMap: '<'
        },
        templateUrl: "static/dataiku/auto-feature-generation/features-count/features-count.component.html",
        controller: function featuresCountController(AutoFeatureGenerationRecipeService) {
            const ctrl = this;
            ctrl.featureCount = AutoFeatureGenerationRecipeService.getFeaturesCount(ctrl.recipeStatus, ctrl.virtualInputs);

            let previousStatus;
            ctrl.$doCheck = () => {
                if (!angular.equals(ctrl.recipeStatus, previousStatus)) {
                    ctrl.featureCount = AutoFeatureGenerationRecipeService.getFeaturesCount(ctrl.recipeStatus, ctrl.virtualInputs);
                    previousStatus = angular.copy(ctrl.recipeStatus);
                }
            }
        }
    };
    angular.module('dataiku.autoFeatureGeneration').component("featuresCount", featuresCount);
})();


