(function(){
'use strict';

var app = angular.module('dataiku.analysis.mlcore',['dataiku.ml.core', 'dataiku.ml.report']);

app.factory("MLTasksNavService", function($state, $stateParams, Fn, Assert, localStorageService) {
    /** Choose to which ml task to go based on the list */
    const ret  = {
        getActiveMLTaskId: (analysisId) => localStorageService.get("analysis." + analysisId + ".activeMLTask"),
        setMlTaskIdToGo: function(analysisId, mlTaskId) {
            return localStorageService.set("analysis." + analysisId + ".activeMLTask", mlTaskId);
        },
        mlTaskIdToGo: function(analysisMLTasks, analysisId) {
            Assert.trueish(analysisMLTasks.length, "No ML task");
            var goTo = ret.getActiveMLTaskId(analysisId);
            if (!goTo || !analysisMLTasks.some(Fn(Fn.prop('mlTaskId'), Fn.eq(goTo)))) {
                goTo = analysisMLTasks[0].mlTaskId;
            }
            Assert.trueish(goTo, "No ML task to go to");
            return goTo;
        },
        link: Fn.dict({ PREDICTION: 'predmltask', CLUSTERING: 'clustmltask' }, false),
        goToCorrectMLTask: function(analysisMLTasks, analysisId) {
            var goTo = ret.mlTaskIdToGo(analysisMLTasks, analysisId),
                mlTask = analysisMLTasks.filter(Fn(Fn.prop('mlTaskId'), Fn.eq(goTo)))[0],
                link = mlTask && ret.link(mlTask.taskType);
            Assert.trueish(link, "cannot resolve ML task link from taskType");
            $state.go("projects.project.analyses.analysis.ml." + link + ".list.results.sessions", {
                    projectKey: $stateParams.projectKey,
                    analysisId: $stateParams.analysisId,
                    mlTaskId: goTo
                }, {location: "replace"});
        }
    };
    return ret;
});


/**
 * The MLTasks list page. We only stay on this page if there is no ML task yet
 */
app.controller("AnalysisMLTasksController", function($scope, DataikuAPI, $q, CreateModalFromTemplate, $state, $stateParams, TopNav, MLTasksNavService){
    TopNav.setLocation(TopNav.TOP_ANALYSES, TopNav.LEFT_ANALYSES, TopNav.TABS_ANALYSIS, "models");
    TopNav.setItem(TopNav.ITEM_ANALYSIS, $stateParams.analysisId);

    DataikuAPI.analysis.getCore($stateParams.projectKey, $stateParams.analysisId).success(function(data) {
        $scope.analysisCoreParams = data;
        TopNav.setItem(TopNav.ITEM_ANALYSIS, $stateParams.analysisId,
            {name: data.name, inputDatasetSmartName: data.inputDatasetSmartName});
        TopNav.setPageTitle(data.name + " - Analysis");

        DataikuAPI.analysis.listMLTasks($stateParams.projectKey, $stateParams.analysisId).success(function(data){
            $scope.analysisMLTasks = data;
            if ($scope.analysisMLTasks.length) {
                MLTasksNavService.goToCorrectMLTask($scope.analysisMLTasks, $stateParams.analysisId);
            }
        });
    }).error(setErrorInScope.bind($scope));

    $scope.createNewMLTask = CreateModalFromTemplate.bind(null,
        "/templates/analysis/new-mltask-modal.html", $scope, "AnalysisNewMLTaskController");
});

app.directive('iframeOnload', [function () {
    return {
        scope: {
            callBack: '&iframeOnload'
        },
        link: function (scope, element, attrs) {
            element.on('load', function () {
                scope.$apply(function () {
                    scope.callBack({element: element[0]});
                });
            })
        }
    }
}]);


app.controller("AnalysisNewMLTaskController", function($scope, $rootScope, $controller, $state, $location, $timeout, DataikuAPI, FeatureFlagsService) {
    $controller("DatasetLabController", { $scope: $scope });
    $scope.datasetSmartName = $scope.analysisCoreParams.inputDatasetSmartName;

    // Override default template creation functions in order to reuse the current Analysis instead of creating new one.
    $scope.useCurrentAnalysisForNewMlTask = true;

    $scope.createClusteringTemplate = function() {
        DataikuAPI.analysis.cml.createAndGuess(
            $scope.analysisCoreParams.projectKey,
            $scope.analysisCoreParams.id,
            $scope.clusteringTaskData.backendType,
            $scope.clusteringTaskData.backendName,
            $scope.clusteringTaskData.selectedPolicy.id
        ).success(data => {
            $rootScope.mlTaskJustCreated = true;
            if ($scope.clusteringTaskData.selectedPolicy.id  === 'ALGORITHMS' || $scope.clusteringTaskData.selectedPolicy.id === 'CUSTOM') {
                $state.go("projects.project.analyses.analysis.ml.clustmltask.list.design.clustering-algorithms", { mlTaskId: data.id });
            } else {
                $state.go("projects.project.analyses.analysis.ml.clustmltask.list.results.sessions", { mlTaskId: data.id });
            }
        }).error(setErrorInScope.bind($scope));
    };

    $scope.mlTaskTypes = [
        {
            name: "AutoML Prediction",
            description: "Understand and predict what is next.",
            img: "icon-dku-automl-prediction",
            openSpecificModal: datasetSmartName => $scope.newPrediction(undefined, datasetSmartName)
        },
        {
            name: "Time Series Forecasting",
            description: "Predict future data based on existing data.",
            img: "icon-dku-timeseries-forecasting",
            openSpecificModal: $scope.newTimeseriesForecastPrediction
        },
        {
            name: "Causal Prediction",
            description: "Predict the effect of a treatment on an outcome",
            img: "icon-dku-causal",
            openSpecificModal: $scope.newCausalPrediction,
        },
        {
            name: "AutoML Clustering",
            description: "Look for patterns in data.",
            img: "icon-dku-automl-clustering",
            openSpecificModal: $scope.newClustering
        },
        {
            name: "Object Detection",
            description: "Locate objects in images.",
            img: "icon-dku-deephub-object-detection",
            openSpecificModal: datasetSmartName => $scope.newDeepHubPrediction(datasetSmartName, 'DEEP_HUB_IMAGE_OBJECT_DETECTION')
        },
        {
            name: "Image Classification",
            description: "Label images into specific classes.",
            img: "icon-dku-deephub-image-classification",
            openSpecificModal: datasetSmartName => $scope.newDeepHubPrediction(datasetSmartName, 'DEEP_HUB_IMAGE_CLASSIFICATION')
        },
    ];
});
})();
