(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('BinnedXYUtils', BinnedXYUtils);

    // (!) This service previously was in static/dataiku/js/simple_report/scatter/aggr_scatter.js
    function BinnedXYUtils() {
        return {
            prepareData: function(chartData) {
                const xLabels = chartData.getAxisLabels('x'),
                    yLabels = chartData.getAxisLabels('y'),
                    points = [];

                xLabels.forEach(function(xLabel, x) {
                    yLabels.forEach(function(yLabel, y) {
                        points.push({ x, y });
                    });
                });

                return points;
            },
            getRadius: function(chartDef, chartWidth, chartHeight) {
                switch (chartDef.hexbinRadiusMode) {
                    case 'ABSOLUTE':
                        return chartDef.hexbinRadius;
                    case 'NUM_HEXAGONS':
                        if (chartWidth < chartHeight) {
                            const hexWidth = Math.floor(chartWidth / chartDef.hexbinNumber);
                            return hexWidth / (2 * Math.cos(Math.PI / 6));
                        } else {
                            const hexHeight = Math.floor(chartHeight / chartDef.hexbinNumber);
                            return hexHeight / 1.5;
                        }
                    default:
                        throw new Error('Unknown hexBinRadiusMode: ' + chartDef.hexbinRadiusMode);
                }
            }
        };
    }
})();
