from . import DatabricksJSONWriter


class RecordOrientedJSONWriter(DatabricksJSONWriter):
    NAME = "INPUT_RECORD_ORIENTED_JSON"

    def __init__(self, client):
        super(RecordOrientedJSONWriter, self).__init__(client)

    def build_request_payload(self, input_df):
        payload = {"dataframe_records": input_df.to_dict(orient='records')}
        return payload
