import requests

def execute(requesting_user, deployment_id, deployment_report, deployer_client, **kwargs):
    """
    Custom hook function.
    
    :param str requesting_user: identifier of the DSS user requesting the deployment
    :param str deployment_id: id of the deployment in progress
    :param deployment_report: status of the deployment and messages related if any.
                              In case of a pre deployment hook, this parameter will be None
                              In case of a post deployment hook, it will be a dictionary with:
                                - "status" for the deployment status, can be "SUCCESS", "WARNING" or "ERROR"
                                - "messages" for the list of messages related to the deployment, as strings 
    :type deployment_report: dict or None
    :param deployer_client: an api client to connect to the deployer node with the credentials of the user running hooks
    :type deployer_client: A :class:`dataikuapi.dssclient.DSSClient`
    
    :returns: The execution status of the hook and a message as string. 
        Use `HookResult.success(message)`, `HookResult.warning(message)` or `HookResult.error(message)`
    """
    slack_webhook_url = 'https://hooks.slack.com/services/TO_BE_FILLED'

    pdpl = deployer_client.get_apideployer()
    deplyt = pdpl.get_deployment(deployment_id).get_settings()
    prj = deplyt.get_raw()['publishedServiceId']
    infra = deplyt.get_raw()['infraId']
    version = deplyt.get_raw()['generationsMapping']['generation']

    json_payload = '{ '
    json_payload += '"blocks" : [ '
    json_payload += '{ "type" : "section",'
    json_payload += '"text": {'
    json_payload += ' "type" : "mrkdwn" , '
    json_payload += ' "text" : ":moon: *New API deployment done* :moon:"'
    json_payload += '}},'
    json_payload += '{ "type" : "section",'
    json_payload += ' "fields" : ['

    json_payload += '{'
    json_payload += '"type": "mrkdwn",'
    json_payload += f'"text": "*Deploying user:*\\n{requesting_user}"'
    json_payload += '},'

    json_payload += '{'
    json_payload += '"type": "mrkdwn",'
    json_payload += f'"text": "*Deploying service:*\\n{prj}"'
    json_payload += '},'

    json_payload += '{'
    json_payload += '"type": "mrkdwn",'
    json_payload += f'"text": "*Deploying version:*\\n{version}"'
    json_payload += '},'

    json_payload += '{'
    json_payload += '"type": "mrkdwn",'
    json_payload += f'"text": "*Deploying infra:*\\n{infra}"'
    json_payload += '},'

    json_payload += ']}]}'

    print("Posting the message to Slack")
    print(json_payload)

    r = requests.post(slack_webhook_url,
                      headers={'Content-Type': 'application/json'},
                      data=json_payload)
    print(r.text)
    r.raise_for_status()
    return HookResult.success("Ok")
    