#!/bin/bash -e
MYDIR=`dirname $0`
MYDIR=`cd $MYDIR && pwd -P`

#############################################################################################
# !!!!!
# IT IS FORBIDDEN TO MODIFY THE VERSIONS OF THE PACKAGES WITHOUT SECURITY REVIEW FIRST
# !!!!!
#############################################################################################

# Helper script to install the builtin env Python packages in the container image
# Call with the PIP_COMMAND as first argument
#
# This script is different from packagers/studio/scripts/install/install-python-packages.sh because in a container,
# we want to:
#   - Minimize a bit what's installed in the builtin env
#   - Notably, pass AWS Inspector and others who may be unhappy about the older versions in the DSS-side builtin env
# 
# So we accept that "DSS-side builtin env" and "container-side builtin env" are not exactly the same. This is notably
# true around ipython, pip, requests, notebook, nbconvert and XGBoost (GPU support)
#
# The actual packages are in $DKUINSTALLDIR/resources/builtin-python-env/container-images
#
# The following files should always be reviewed together when touching the builtin env
#    packagers/studio/scripts/install/install-python-packages.sh
#    packagers/studio/scripts/install/install-python-packages.ps1
#    packagers/fm/scripts/install/install-python-packages.sh
#    resources/container-exec/install-builtin-env-python-packages.sh
#    resources/builtin-python-env/dss-server
#    resources/builtin-python-env/container-images
#    packagers/resource-build/python (ultimately run/built by Patrice)
# In addition, make sure to keep it in sync with the various files in resources/code-envs/python

pip="$1"
pip_install_options="$2"

# Grab Python version from "pip -V" output
pipVersion=$($pip -V)
pythonVersion=$(sed -n 's/^pip .* (python \([0-9]\.[0-9]*\))$/\1/p' <<<"$pipVersion")
if [ -z "$pythonVersion" ]; then
    echo >&2 "*** Error: could not retrieve python version"
    exit 1
fi

case "$pythonVersion" in
     "3.9")
        requirementsFile="$MYDIR/requirements-py39.txt"
        ;;
     "3.10")
        requirementsFile="$MYDIR/requirements-py310.txt"
        ;;
     "3.11")
        requirementsFile="$MYDIR/requirements-py311.txt"
        ;;
    *)
        echo >&2 "*** Error: python version not supported: $pythonVersion"
        exit 1
esac

echo "+ Upgrading pip"
$pip install $pip_install_options --upgrade pip wheel setuptools

echo "+ Installing required Python packages ..."
$pip install $pip_install_options -r "$requirementsFile"

# Remove stuff installed only temporarily or that we don't want
echo "+ Cleaning up ..."

# nbconvert and notebook are not actually needed in the container
$pip uninstall --yes nbconvert notebook widgetsnbextension jupyterlab-widgets

# Remove known tests folders
for library in sklearn statsmodels pandas numpy scipy; do
  find /opt/dataiku/pyenv/ -depth -type d \( \-wholename "*/site-packages/${library}/tests" -or -wholename "*/site-packages/${library}/*/tests" \) -exec rm -rf {} \;
done

# Remove known test folders
for library in jedi joblib tornado; do
  find /opt/dataiku/pyenv/ -depth -type d \( \-wholename "*/site-packages/${library}/test" -or -wholename "*/site-packages/${library}/*/test" \) -exec rm -rf {} \;
done

# The "webagg" backend has a deprecated jQuery-UI that triggers security scanners, nuke it
rm -rf /opt/dataiku/pyenv/lib*/python*/site-packages/matplotlib/backends/web_backend
# The "tornado" library has a test file that falsely triggers security scanners [sc-113388]
rm -rf /opt/dataiku/pyenv/lib*/python*/site-packages/tornado/test/test.key
# The xgboost library has a dependency on yarn which depends on log4j and falsely triggers security scanners [sc-256412]
rm -rf /opt/dataiku/pyenv/lib*/python*/site-packages/xgboost/dmlc-core/tracker/yarn/pom.xml
