
$BINDIR=$env:BINDIR # Get dirname from the callee

$env:DIP_HOME=Split-Path -Path $BINDIR # dirname $BINDIR
$DIP_HOME=$env:DIP_HOME

& $BINDIR/env-default.ps1

if ($null -eq $env:DKUINSTALLDIR) {
    Write-Output "FATAL: DKUINSTALLDIR is not defined. Please check $BINDIR\env-default.ps1"
    Exit
}

# . = call in same  scope, to access functions
. $env:DKUINSTALLDIR/scripts/_startup.inc.ps1

bkdl_set_py_env
bkdl_set_R_env
bkdl_load_env_files

bkdl_env_sanity_check

$env:DKUBIN="$BINDIR/dku.cmd"
$env:PYTHONPATH="$DIP_HOME/lib/python;$env:DKUINSTALLDIR/python"

if ($args[0] -Match "-s") {
    $env:DKU_SILENT=1
    $null, $args = $args # Equivalent to "shift" in bash
}

$_CP=bkdl_get_cp

$params = "$env:DKU_JAVA_OPTS".Split(" ")
$params+= "$env:DKU_DKU_JAVA_OPTS".Split(" ")
$params+="-Ddku.dku",
  "-XX:+CrashOnOutOfMemoryError",
  "-XX:ErrorFile=`"$env:DIP_HOME/run/hs_err_pid%p.log`"",
  "-Djava.library.path=`"$env:DKU_DKU_JAVA_LIBRARY_PATH:$env:DKU_HADOOP_JAVA_LIBRARY_PATH`"",
  "-cp",
  $_CP,
  "com.dataiku.dip.cli.DKU"
$params+=$args
& "$env:DKUJAVABIN" $params
