/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit;

import java.util.List;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateSessionRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class AWSRequestAnalyzer {
    private static final String BYTES_PREFIX = "bytes=";

    public RequestInfo analyze(SdkRequest request) {
        if (request instanceof AbortMultipartUploadRequest) {
            return this.writing("multipart_upload_aborted", ((AbortMultipartUploadRequest)request).key(), 0);
        }
        if (request instanceof CompleteMultipartUploadRequest) {
            CompleteMultipartUploadRequest r = (CompleteMultipartUploadRequest)request;
            return this.writing("multipart_upload_completed", r.key(), r.multipartUpload().parts().size());
        }
        if (request instanceof CreateMultipartUploadRequest) {
            return this.writing("multipart_upload_started", ((CreateMultipartUploadRequest)request).key(), 0);
        }
        if (request instanceof DeleteObjectRequest) {
            return this.writing("object_delete_request", ((DeleteObjectRequest)request).key(), 1);
        }
        if (request instanceof DeleteObjectsRequest) {
            DeleteObjectsRequest r = (DeleteObjectsRequest)request;
            List objectIdentifiers = r.delete().objects();
            return this.writing("object_bulk_delete_request", objectIdentifiers.isEmpty() ? null : ((ObjectIdentifier)objectIdentifiers.get(0)).key(), objectIdentifiers.size());
        }
        if (request instanceof GetBucketLocationRequest) {
            GetBucketLocationRequest r = (GetBucketLocationRequest)request;
            return this.reading("store_exists_probe", r.bucket(), 0);
        }
        if (request instanceof GetObjectRequest) {
            GetObjectRequest r = (GetObjectRequest)request;
            return this.reading("action_http_get_request", r.key(), AWSRequestAnalyzer.sizeFromRangeHeader(r.range()));
        }
        if (request instanceof HeadObjectRequest) {
            return this.reading("action_http_head_request", ((HeadObjectRequest)request).key(), 0);
        }
        if (request instanceof ListMultipartUploadsRequest) {
            ListMultipartUploadsRequest r = (ListMultipartUploadsRequest)request;
            return this.reading("multipart_upload_list", r.prefix(), r.maxUploads());
        }
        if (request instanceof ListObjectsRequest) {
            ListObjectsRequest r = (ListObjectsRequest)request;
            return this.reading("object_list_request", r.prefix(), r.maxKeys());
        }
        if (request instanceof ListObjectsV2Request) {
            ListObjectsV2Request r = (ListObjectsV2Request)request;
            return this.reading("object_list_request", r.prefix(), r.maxKeys());
        }
        if (request instanceof PutObjectRequest) {
            PutObjectRequest r = (PutObjectRequest)request;
            return this.writing("object_put_request", r.key(), 0);
        }
        if (request instanceof UploadPartRequest) {
            UploadPartRequest r = (UploadPartRequest)request;
            return this.writing("multipart_upload_part_put", r.key(), r.contentLength());
        }
        return this.writing(request.getClass().getName(), null, 0);
    }

    private RequestInfo request(String verb, boolean mutating, String key, Number size) {
        return new RequestInfo(verb, mutating, key, size);
    }

    private RequestInfo reading(String verb, String key, Number size) {
        return this.request(verb, false, key, size);
    }

    private RequestInfo writing(String verb, String key, Number size) {
        return this.request(verb, true, key, size);
    }

    public static boolean isRequestNotAlwaysInSpan(Object request) {
        return request instanceof UploadPartCopyRequest || request instanceof CompleteMultipartUploadRequest || request instanceof GetBucketLocationRequest || request instanceof CreateSessionRequest;
    }

    public static boolean isRequestMultipartIO(Object request) {
        return request instanceof UploadPartCopyRequest || request instanceof CompleteMultipartUploadRequest || request instanceof CreateMultipartUploadRequest || request instanceof UploadPartRequest;
    }

    private static long toSafeLong(Number size) {
        return size != null ? size.longValue() : 0L;
    }

    private static Number sizeFromRangeHeader(String rangeHeader) {
        String[] values;
        if (rangeHeader != null && rangeHeader.startsWith(BYTES_PREFIX) && (values = rangeHeader.substring(BYTES_PREFIX.length()).split("-")).length == 2) {
            try {
                long start = Long.parseUnsignedLong(values[0]);
                long end = Long.parseUnsignedLong(values[1]);
                return end - start;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static final class RequestInfo {
        private String verb;
        private boolean mutating;
        private String key;
        private long size;

        private RequestInfo(String verb, boolean mutating, String key, Number size) {
            this.verb = verb;
            this.mutating = mutating;
            this.key = key;
            this.size = AWSRequestAnalyzer.toSafeLong(size);
        }

        public String getVerb() {
            return this.verb;
        }

        public boolean isMutating() {
            return this.mutating;
        }

        public String getKey() {
            return this.key;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            sb.append(this.verb);
            if (this.key != null) {
                sb.append(" '").append(this.key).append('\'');
            }
            sb.append(" size=").append(this.size);
            sb.append(", mutating=").append(this.mutating);
            sb.append('}');
            return sb.toString();
        }
    }
}

