/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.util.Optional;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;

public final class EncryptionSecretOperations {
    private EncryptionSecretOperations() {
    }

    public static Optional<String> getSSECustomerKey(EncryptionSecrets secrets) {
        if (secrets.hasEncryptionKey() && secrets.getEncryptionMethod() == S3AEncryptionMethods.SSE_C) {
            return Optional.of(secrets.getEncryptionKey());
        }
        return Optional.empty();
    }

    public static Optional<String> getSSEAwsKMSKey(EncryptionSecrets secrets) {
        if ((secrets.getEncryptionMethod() == S3AEncryptionMethods.SSE_KMS || secrets.getEncryptionMethod() == S3AEncryptionMethods.DSSE_KMS) && secrets.hasEncryptionKey()) {
            return Optional.of(secrets.getEncryptionKey());
        }
        return Optional.empty();
    }
}

