/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import com.microsoft.azure.datalake.store.ReadBuffer;
import com.microsoft.azure.datalake.store.ReadBufferManager;
import com.microsoft.azure.datalake.store.ReadBufferStatus;
import java.util.concurrent.CountDownLatch;

class ReadBufferWorker
implements Runnable {
    static final CountDownLatch unleashWorkers = new CountDownLatch(1);
    private int id;

    ReadBufferWorker(int id) {
        this.id = id;
    }

    @Override
    public void run() {
        try {
            unleashWorkers.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        ReadBufferManager bufferManager = ReadBufferManager.getBufferManager();
        while (true) {
            ReadBuffer buffer;
            try {
                buffer = bufferManager.getNextBlockToRead();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (buffer == null) continue;
            try {
                int bytesRead = buffer.file.readRemote(buffer.offset, buffer.buffer, 0, buffer.requestedLength, true);
                bufferManager.doneReading(buffer, ReadBufferStatus.AVAILABLE, bytesRead);
                continue;
            }
            catch (Exception ex) {
                bufferManager.doneReading(buffer, ReadBufferStatus.READ_FAILED, 0);
                continue;
            }
            break;
        }
    }
}

