/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.summary;

import java.util.Map;
import org.apache.parquet.pig.summary.FieldSummaryData;
import org.apache.parquet.pig.summary.SummaryData;
import org.apache.parquet.pig.summary.ValueStat;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class MapSummaryData
extends SummaryData {
    private ValueStat size = new ValueStat();
    private FieldSummaryData key;
    private FieldSummaryData value;

    public void add(Schema schema, Map<?, ?> m) {
        super.add(m);
        this.size.add(m.size());
        Schema.FieldSchema field = this.getField(schema, 0);
        if (!m.isEmpty() && this.key == null) {
            this.key = new FieldSummaryData();
            this.key.setName(this.getName(field));
            this.value = new FieldSummaryData();
            this.value.setName(this.getName(field));
        }
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            this.key.add(null, entry.getKey());
            this.value.add(this.getSchema(field), entry.getValue());
        }
    }

    @Override
    public void merge(SummaryData other) {
        super.merge(other);
        MapSummaryData otherMapSummaryData = (MapSummaryData)other;
        this.size.merge(otherMapSummaryData.size);
        this.key = MapSummaryData.merge(this.key, otherMapSummaryData.key);
        this.value = MapSummaryData.merge(this.value, otherMapSummaryData.value);
    }

    public FieldSummaryData getKey() {
        return this.key;
    }

    public void setKey(FieldSummaryData key) {
        this.key = key;
    }

    public FieldSummaryData getValue() {
        return this.value;
    }

    public void setValue(FieldSummaryData value) {
        this.value = value;
    }

    public ValueStat getSize() {
        return this.size;
    }

    public void setSize(ValueStat size) {
        this.size = size;
    }
}

