/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.WeightedTargetLoadBalancer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class WeightedTargetLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public WeightedTargetLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    WeightedTargetLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "weighted_target_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WeightedTargetLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Map<String, ?> targets = JsonUtil.getObject(rawConfig, "targets");
            if (targets == null || targets.isEmpty()) {
                return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No targets provided for weighted_target LB policy:\n " + rawConfig));
            }
            LinkedHashMap<String, WeightedPolicySelection> parsedChildConfigs = new LinkedHashMap<String, WeightedPolicySelection>();
            for (String name : targets.keySet()) {
                Map<String, ?> rawWeightedTarget = JsonUtil.getObject(targets, name);
                if (rawWeightedTarget == null || rawWeightedTarget.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No config for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                Integer weight = JsonUtil.getNumberAsInteger(rawWeightedTarget, "weight");
                if (weight == null || weight < 1) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("Wrong weight for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                List<ServiceConfigUtil.LbConfig> childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(rawWeightedTarget, "childPolicy"));
                if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No child policy for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                LoadBalancerRegistry lbRegistry = this.lbRegistry == null ? LoadBalancerRegistry.getDefaultRegistry() : this.lbRegistry;
                NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList(childConfigCandidates, lbRegistry);
                if (selectedConfig.getError() != null) {
                    return selectedConfig;
                }
                ServiceConfigUtil.PolicySelection policySelection = (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig();
                parsedChildConfigs.put(name, new WeightedPolicySelection(weight, policySelection));
            }
            return NameResolver.ConfigOrError.fromConfig(new WeightedTargetConfig(parsedChildConfigs));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(e).withDescription("Failed to parse weighted_target LB config: " + rawConfig));
        }
    }

    static final class WeightedTargetConfig {
        final Map<String, WeightedPolicySelection> targets;

        WeightedTargetConfig(Map<String, WeightedPolicySelection> targets) {
            this.targets = targets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedTargetConfig that = (WeightedTargetConfig)o;
            return Objects.equals(this.targets, that.targets);
        }

        public int hashCode() {
            return Objects.hashCode(this.targets);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("targets", this.targets).toString();
        }
    }

    static final class WeightedPolicySelection {
        final int weight;
        final ServiceConfigUtil.PolicySelection policySelection;

        WeightedPolicySelection(int weight, ServiceConfigUtil.PolicySelection policySelection) {
            this.weight = weight;
            this.policySelection = policySelection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedPolicySelection that = (WeightedPolicySelection)o;
            return this.weight == that.weight && Objects.equals(this.policySelection, that.policySelection);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.policySelection);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("weight", this.weight).add("policySelection", this.policySelection).toString();
        }
    }
}

