/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.util.SecretKeyGenerator;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LambdaIntercomApiSecretAuthService {
    private static final String AUDIT_LOG_REF_UNAUTHORIZED_INTERNAL_CALL = "unauthorizedInternalCall";
    static final String HEADER_KEY = "X-DKU-PythonIntercomApiSecret";
    private final String SECRET = SecretKeyGenerator.generate((int)64);

    public String getInternalApiSecret() {
        return this.SECRET;
    }

    public void failIfNoInternalApiSecret(HttpServletRequest req) throws SecurityException {
        String ss = req.getHeader(HEADER_KEY);
        if (ss == null || !StringUtils.equals((String)ss.trim(), (String)this.SECRET)) {
            AuditContextBase.addCustom((String)AUDIT_LOG_REF_UNAUTHORIZED_INTERNAL_CALL, (String)"true");
            throw new SecurityException("You are not allowed to call this API");
        }
        AuditContextBase.addCustom((String)AUDIT_LOG_REF_UNAUTHORIZED_INTERNAL_CALL, (String)"false");
    }
}

