/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class CrossValidationStrategyExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TabularPredictionModelDetails)) {
            return "No cross validation strategy";
        }
        TabularPredictionModelDetails predictionModelDetails = (TabularPredictionModelDetails)model;
        if (predictionModelDetails.modeling != null && predictionModelDetails.modeling.grid_search_params != null && predictionModelDetails.modeling.grid_search_params.mode != null) {
            for (GridSearchParamsMode mode : GridSearchParamsMode.values()) {
                if (!mode.name().equals(predictionModelDetails.modeling.grid_search_params.mode.name())) continue;
                return mode.getUserFriendlyName();
            }
            return predictionModelDetails.modeling.grid_search_params.mode.name();
        }
        return "No cross validation strategy";
    }

    public static enum GridSearchParamsMode {
        SHUFFLE("Simple train/validation split"),
        KFOLD("K-fold"),
        TIME_SERIES_KFOLD("Time-based K-fold (with overlap)"),
        TIME_SERIES_SINGLE_SPLIT("Time-based train/validation split"),
        CUSTOM("Custom code");

        private String userFriendlyName;

        private GridSearchParamsMode(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

