/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.core.PostTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import java.io.IOException;
import java.util.List;

public abstract class GenericTimeseriesExtractor
implements ModelExtractor<List<List<String>>> {
    void canExtract(ModelDetailsBase model, List<PreTrainPredictionModelingParams.Algorithm> supportedAlgorithms) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        PostTrainModelingParams resolvedParams = timeseriesModelDetails.actualParams.resolved;
        if (!(resolvedParams instanceof PostTrainPredictionModelingParams)) {
            throw new IOException(String.format("Extractor '%s' does not support PostTrainModelingParams of type '%s'", this.getClass().getSimpleName(), resolvedParams.getClass().getSimpleName()));
        }
        PostTrainPredictionModelingParams predictionModelingParams = (PostTrainPredictionModelingParams)resolvedParams;
        if (!supportedAlgorithms.contains((Object)predictionModelingParams.algorithm)) {
            throw new IOException(String.format("Extractor '%s' does not support algorithms of type '%s'", new Object[]{this.getClass().getSimpleName(), predictionModelingParams.algorithm}));
        }
    }
}

