/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisMLContainerKernel;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.ClusteringRescoringHandler;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class PythonClusteringRescoringHandler
extends ClusteringRescoringHandler {
    private final FullModelId modelId;
    private final AuthCtx authCtx;
    private IAnalysisMLKernel kernel;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.ml.python");

    public PythonClusteringRescoringHandler(AuthCtx authCtx, FullModelId modelId) {
        this.authCtx = authCtx;
        this.modelId = modelId;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void abort() throws Exception {
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescore() throws Exception {
        block39: {
            ComputeResourceUsageContext cruContext;
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            ResolvedCoreParams rcp = this.modelId.getResolvedCoreParams();
            String envName = rcp.executionParams.envName;
            ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(this.authCtx, this.modelId.getProjectKey(), rcp.executionParams.containerSelection, rcp.backendType);
            if (this.modelId.type == FullModelId.Type.ANALYSIS) {
                MLTaskLoc taskLoc = this.modelId.getTaskLoc();
                cruContext = ComputeResourceUsageContext.forAnalysisMLTrain((AuthCtx)this.authCtx, (String)taskLoc.analysisProjectKey, (String)taskLoc.analysisId, (String)taskLoc.mlTaskId, (String)this.modelId.getSessionId());
            } else {
                cruContext = ComputeResourceUsageContext.forSavedMLOperation((AuthCtx)this.authCtx, (String)this.modelId.getProjectKey(), (String)this.modelId.getSavedModelID(), (String)this.modelId.getSavedModelVersionID());
            }
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
            SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), dssPortRange, containerConfig != null ? EncryptedRPC.getSSLContext() : null);
            this.kernel = containerConfig == null ? new AnalysisMLKernel(link, null, this.modelId.getProjectKey(), envName, this.authCtx, this.modelId.getModelFolder()) : new AnalysisMLContainerKernel(link, null, this.modelId.getProjectKey(), envName, this.authCtx, this.modelId.getPreprocessingFolder(), MLPaths.getContextDir(this.modelId), containerConfig, "doctor-cluster-score-");
            Exception error = null;
            try {
                FilesystemACLUtils.grantFSReadACLs(this.authCtx, this.modelId.getProjectKey(), this.modelId.getFolderEnsuringSecurity());
                this.kernel.start();
                JsonObject command = new JsonObject();
                command.addProperty("split_desc", JSON.json((Object)this.modelId.getSplitDesc()));
                command.addProperty("model_folder", this.modelId.getModelFolder().getAbsolutePath());
                command.addProperty("preprocessing_folder", this.modelId.getPreprocessingFolder().getAbsolutePath());
                command.addProperty("split_folder", this.modelId.getSplitFolder().getAbsolutePath());
                try {
                    link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest("clustering_rescore", JSON.json((Object)command)), null, String.class, "Failed to rescore").call();
                }
                catch (SocketBlockLinkException e) {
                    throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Rescoring failed", (Throwable)e);
                error = e;
            }
            catch (Exception e) {
                logger.warn((Object)"Rescoring failed", (Throwable)e);
                error = e;
            }
            finally {
                CurrentComputeResourceUsageContext.clear();
                try {
                    if (!this.kernel.isAborted()) {
                        if (error == null) {
                            try {
                                this.kernel.waitForResults();
                            }
                            catch (TimeoutException e) {
                                error = e;
                            }
                        } else {
                            SerializedError serializedError = this.kernel.waitForError();
                            if (serializedError != null) {
                                error = new APIError.SerializedErrorException(serializedError);
                            }
                        }
                    }
                    this.kernel.cleanup();
                    this.kernel.killWithoutMercy();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while destroying rescoring kernel", (Throwable)e);
                }
                try {
                    link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while closing link to kernel", (Throwable)e);
                }
                this.kernel = null;
                if (error == null) break block39;
                throw error;
            }
        }
    }
}

