/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.ModelVersioning;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ModelStateHelper;
import com.dataiku.dip.analysis.ml.shared.PRNSTrainThread;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;

public class PredictionTrainAdditionalThread
extends PRNSTrainThread {
    private final ResolvedPredictionCoreParams rpcp;
    private final PredictionMLTask task;
    private final String command;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.prediction");

    public PredictionTrainAdditionalThread(AuthCtx authCtx, Queue<WorkSet.PreprocessingSet> workQueue, List<FullModelId> fullModelIds, SplitDesc splitDesc, MLTaskLoc taskLoc, ResolvedPredictionCoreParams rpcp, String sessionId, PredictionMLTask task, Object sync, String command) {
        super(authCtx, workQueue, splitDesc, taskLoc, new ArrayList<String>(), sessionId, sync);
        if (fullModelIds != null) {
            for (FullModelId fmi : fullModelIds) {
                this.fullModelIds.add(fmi.toString());
            }
        }
        this.task = task;
        this.command = command;
        this.rpcp = rpcp;
    }

    @Override
    public String getProjectKey() {
        return this.taskLoc.analysisProjectKey;
    }

    @Override
    public String getEnvName() {
        return this.rpcp.executionParams.envName;
    }

    @Override
    public PredictionMLTask getTask() {
        return this.task;
    }

    @Override
    public void process(WorkSet.PreprocessingSet pps) throws Exception {
        if (this.shallNotProcess(pps)) {
            logger.info((Object)("Not processing pps: " + pps.preprocessingId));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("core_params", this.rpcp);
        map.put("preprocessing_set", this.remapPreprocessingSet(pps, this.kernel));
        map.put("split_desc", this.getSplitDesc());
        map.put("ml_overrides_params", this.task.getOverridesParams());
        try {
            String trainRet = (String)pps.link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest(this.command, JSON.pretty(map)), null, String.class, "Failed to train").call();
            logger.info((Object)("Training returned " + trainRet));
        }
        catch (SocketBlockLinkException e) {
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
        }
        ModelVersioning.dumpTrainVersionInfo(this.task.backendType, new File(pps.modelingSets.get((int)0).run_folder));
    }

    @Override
    protected boolean shallNotProcess(WorkSet.PreprocessingSet pps) {
        String firstFMI = new FullModelId(this.taskLoc, this.sessionId, pps.preprocessingId, pps.modelingSets.get((int)0).modelId).toString();
        return !this.fullModelIds.isEmpty() && !this.fullModelIds.contains(firstFMI);
    }

    @Override
    public void postProcess(WorkSet.PreprocessingSet pps) throws IOException {
        ModelStateHelper.updatePredictionTrainInfoAndUserMeta(this.task.predictionType, pps);
    }
}

