/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class DBScanMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "DBScan (eps=" + rpmp.epsilon + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "epsilon=" + rpmp.epsilon + ", msr=" + rpmp.min_sample_ratio;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.DBScanParams dbscan = task.modeling.db_scan_clustering;
        if (dbscan.enabled) {
            ErrorContext.checkNotEmpty((double[])dbscan.epsilon, (String)"DBSCAN requires an epsilon value");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.DBScanParams dbscan = task.modeling.db_scan_clustering;
        if (dbscan.enabled) {
            for (double epsilon : dbscan.epsilon) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.DBSCAN);
                rcmp.epsilon = epsilon;
                rcmp.min_sample_ratio = dbscan.min_sample_ratio;
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

