/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.shared.ParamsExpander;
import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PredictionPreprocessingParams;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeepHubParamsExpander
extends ParamsExpander {
    private final PredictionMLTask.DeepHubPredictionMLTask task;
    private final String sessionId;

    public DeepHubParamsExpander(PredictionMLTask.DeepHubPredictionMLTask task, String sessionId) {
        this.task = task;
        this.sessionId = sessionId;
    }

    @Override
    protected List<WorkSet.PreprocessingSet> expandPreprocessing() {
        PredictionPreprocessingParams ppp = this.task.getPreprocessingParams();
        ArrayList<WorkSet.PreprocessingSet> ret = new ArrayList<WorkSet.PreprocessingSet>();
        ResolvedPredictionPreprocessingParams rppp = new ResolvedPredictionPreprocessingParams();
        rppp.per_feature = (Map)JSON.deepCopy((Object)ppp.per_feature);
        rppp.target_remapping = ppp.target_remapping;
        WorkSet.PreprocessingSet ps2 = new WorkSet.PreprocessingSet(rppp, "");
        ps2.needsTmpFolder = true;
        ret.add(ps2);
        return ret;
    }

    public WorkSet expand() throws Exception {
        WorkSet ws = new WorkSet(this.sessionId);
        ParameterChecks checks = new ParameterChecks();
        try {
            DKUMLUtils.checkPredictionTask(this.task);
        }
        catch (Exception e) {
            checks.addError(e.getMessage(), null);
            ws.messages = checks.getMessages();
            return ws;
        }
        this.task.modeling.validateParameters(this.task, checks);
        WorkSet.ModelingSet ms = new WorkSet.ModelingSet(this.task.modeling);
        this.addModelingSets(Lists.newArrayList((Object[])new WorkSet.ModelingSet[]{ms}), ws);
        ws.messages = checks.getMessages();
        return ws;
    }
}

