/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class PartitionedModelExtract {
    public Map<PartitionState, Integer> states = new EnumMap<PartitionState, Integer>(PartitionState.class);
    public Map<String, PartitionedModelSummary> summaries = new HashMap<String, PartitionedModelSummary>();
    public Map<String, String> versions = new HashMap<String, String>();

    public String toString() {
        return String.format("PartitionedModelExtract{states=%s, summaries=%s, versions=%s}", this.states, this.summaries, this.versions);
    }

    public void setStatesToReused() {
        EnumMap<PartitionState, Integer> updatedStates = new EnumMap<PartitionState, Integer>(PartitionState.class);
        for (Map.Entry<PartitionState, Integer> stateEntry : this.states.entrySet()) {
            PartitionState newState = stateEntry.getKey().toReused();
            int newStateCount = stateEntry.getValue();
            if (updatedStates.containsKey((Object)newState)) {
                newStateCount += ((Integer)updatedStates.get((Object)newState)).intValue();
            }
            updatedStates.put(newState, newStateCount);
        }
        this.states = updatedStates;
        for (PartitionedModelSummary summary : this.summaries.values()) {
            summary.state = summary.state.toReused();
        }
    }

    public void setState(String partitionName, ModelTrainInfo.ModelTrainState newState) {
        PartitionedModelSummary partSummary = this.summaries.get(partitionName);
        PartitionState newPartState = PartitionState.fromModelTrainState(newState);
        if (partSummary != null) {
            PartitionState oldPartState = partSummary.state;
            this.states.put(oldPartState, this.states.get((Object)oldPartState) - 1);
            partSummary.state = newPartState;
        }
        Integer newStateCount = (Integer)ObjectUtils.defaultIfNull((Object)this.states.get((Object)newPartState), (Object)0);
        this.states.put(newPartState, newStateCount + 1);
    }

    public void decreaseState(PartitionState state) {
        Integer amount = this.states.get((Object)state);
        if (amount != null) {
            this.states.put(state, amount - 1);
        }
    }

    public void increaseState(PartitionState state) {
        Integer amount = this.states.get((Object)state);
        if (amount == null) {
            amount = 0;
        }
        this.states.put(state, amount + 1);
    }

    public static Gson createGsonWithLimitedSummaries() {
        Type mapOfStringToSummary = new TypeToken<Map<String, PartitionedModelSummary>>(){}.getType();
        return JSON.createGsonBuilder().registerTypeAdapter(mapOfStringToSummary, (Object)new SampleMapSerializer()).create();
    }

    public static enum PartitionState {
        REUSED_PENDING,
        REUSED_RUNNING,
        REUSED_DONE,
        REUSED_FAILED,
        REUSED_ABORTED,
        PENDING(REUSED_PENDING),
        RUNNING(REUSED_RUNNING),
        DONE(REUSED_DONE),
        FAILED(REUSED_FAILED),
        ABORTED(REUSED_ABORTED);

        private final PartitionState reused;

        private PartitionState() {
            this.reused = this;
        }

        private PartitionState(PartitionState reused) {
            this.reused = reused;
        }

        public static PartitionState fromModelTrainState(ModelTrainInfo.ModelTrainState trainState) {
            return PartitionState.valueOf(trainState.name());
        }

        public boolean isUsable() {
            return this == DONE || this == REUSED_DONE;
        }

        public PartitionState toReused() {
            return this.reused;
        }
    }

    public static class PartitionedModelSummary {
        public PredictionModelSnippetData snippet;
        public PartitionState state;

        public PartitionedModelSummary(PredictionModelSnippetData snippet, PartitionState state) {
            this.snippet = snippet;
            this.state = state;
        }

        public PartitionedModelSummary(PredictionModelSnippetData snippet) {
            this(snippet, PartitionState.fromModelTrainState(snippet.trainInfo.state));
        }

        public PartitionedModelSummary(PartitionState state, FullModelId fmi) {
            this.snippet = new PredictionModelSnippetData();
            this.snippet.fullModelId = fmi.toString();
            this.state = state;
        }

        public String toString() {
            return String.format("PartitionedModelSummary{snippet.fullModelId=%s, state=%s}", new Object[]{this.snippet.fullModelId, this.state});
        }
    }

    private static class SampleMapSerializer
    implements JsonSerializer<Map<String, PartitionedModelSummary>> {
        private static final int PREVIEW_SIZE = 6;

        private SampleMapSerializer() {
        }

        public JsonElement serialize(Map<String, PartitionedModelSummary> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            for (Map.Entry<String, PartitionedModelSummary> summaryEntry : src.entrySet()) {
                result.add(summaryEntry.getKey(), context.serialize((Object)summaryEntry.getValue()));
                if (result.size() != 6) continue;
                break;
            }
            return result;
        }
    }
}

