/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.engine;

import com.dataiku.dip.apideployer.engine.DeploymentHooksRunRequest;
import com.dataiku.dip.dataflow.kernel.master.locking.AcquirabilityTestResult;
import com.dataiku.dip.dataflow.kernel.master.locking.SchedulingConstraintPolicy;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;

public class DeploymentHooksRunLimiter
implements SchedulingConstraintPolicy<DeploymentHooksRunRequest> {
    private final int maxKernels;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.hooks.run.limiter");

    public DeploymentHooksRunLimiter(int maxKernels) {
        this.maxKernels = maxKernels;
    }

    @Override
    public SchedulingConstraintPolicy.ConstraintChecker<DeploymentHooksRunRequest> newConstraintChecker(final List<DeploymentHooksRunRequest> acquiredPermits) {
        return new SchedulingConstraintPolicy.ConstraintChecker<DeploymentHooksRunRequest>(){

            @Override
            public AcquirabilityTestResult canBeAcquired(DeploymentHooksRunRequest candidatePermit) {
                if (acquiredPermits.size() >= DeploymentHooksRunLimiter.this.maxKernels) {
                    logger.warnV("The global limit of deployment hooks kernels has already been reached, cannot authorize a new one (active: %d/maximum: %d)", new Object[]{acquiredPermits.size(), DeploymentHooksRunLimiter.this.maxKernels});
                    return AcquirabilityTestResult.no("The global limit of " + DeploymentHooksRunLimiter.this.maxKernels + " running deployment hooks has been reached.");
                }
                long count = acquiredPermits.stream().filter(p -> p.getPermitGroupKey().equals(candidatePermit.getPermitGroupKey())).count();
                if (count >= (long)candidatePermit.infra.deploymentHookSettings.maxHooksKernels) {
                    logger.warnV("The maximum number of deployment hooks kernels for infra %s has already been reached, cannot authorize a new one (active: %d/maximum: %d)", new Object[]{candidatePermit.getPermitGroupKey(), count, candidatePermit.infra.deploymentHookSettings.maxHooksKernels});
                    return AcquirabilityTestResult.no("The limit of " + candidatePermit.infra.deploymentHookSettings.maxHooksKernels + " running deployment hooks for this infra has been reached.");
                }
                logger.infoV("Allowing to create a new deployment hooks kernel for infra %s", new Object[]{candidatePermit.getPermitGroupKey()});
                return AcquirabilityTestResult.yes();
            }
        };
    }
}

