/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EntrypointCodeStudioBlockMeta
implements CodeStudioBlockMeta {
    public static final String TYPE = "entrypoint";
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.entrypoint");

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return EntrypointCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Add an Entrypoint";
        ret.description = "Add an Entrypoint to the Code Studio, and an associated port forward exposition";
        ret.icon = "icon-signin";
        ret.isAdvanced = true;
        ret.uiDisplayPriority = 1030;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        EntrypointCodeStudioBlockParams params = block.getParamsAs(EntrypointCodeStudioBlockParams.class);
        StringBuilder dockerfileBuilder = new StringBuilder(StringUtils.defaultIfBlank((String)buildSpec.dockerfile, (String)""));
        dockerfileBuilder.append("\n\n##### ENTRYPOINT BLOCK " + StringUtils.defaultIfBlank((String)params.label, (String)"") + " #####");
        dockerfileBuilder.append("\nUSER root\nWORKDIR /opt/dataiku\n");
        String entrypointsDir = "entrypoints_" + SecretKeyGenerator.generateSmall();
        VariablesContext vc = CodeStudioTemplatesService.getTemplateVariablesContext(template.id);
        for (SimpleKeyValue copy : params.scripts) {
            String fromPath = vc.expand(copy.key);
            File from = new File(fromPath);
            String toPath = copy.value;
            String fileName = toPath.endsWith("/") ? from.getName() : PathUtils.getLastPathSegment((String)toPath);
            File to = new File(buildEnv.buildDir + "/" + entrypointsDir, fileName);
            if (!from.exists()) {
                throw new FileNotFoundException("Copy script " + fromPath + " doesn't exist");
            }
            if (from.isDirectory()) {
                throw new FileNotFoundException("Copy script " + fromPath + " must be a file");
            }
            if (!from.canRead()) {
                throw new FileNotFoundException("Can't read source " + fromPath);
            }
            logger.info((Object)("Copying " + from.getAbsolutePath() + " to " + to.getAbsolutePath()));
            FileUtils.copyFile((File)from, (File)to);
            Object toCopy = toPath.startsWith("/") ? toPath : "/home/dataiku/" + toPath;
            dockerfileBuilder.append("\nCOPY " + entrypointsDir + "/" + fileName + " " + (String)toCopy);
            dockerfileBuilder.append("\nRUN chown dataiku: " + (String)toCopy + " \\\n  && chmod u+x " + (String)toCopy);
        }
        dockerfileBuilder.append("\n\nUSER " + DKUApp.getContainerUIDGID() + "\nWORKDIR /home/dataiku\n");
        buildSpec.dockerfile = dockerfileBuilder.toString();
        return buildSpec;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        EntrypointCodeStudioBlockParams params = block.getParamsAs(EntrypointCodeStudioBlockParams.class);
        if (launchEnv.launchedFrom == CodeStudioMeta.CodeStudioLaunchedFrom.CODE_STUDIO || params.useInWebapps) {
            if (StringUtils.isNotBlank((String)params.entrypoint)) {
                launchSpec.entrypoints.add(params.entrypoint);
            }
            if (params.exposedPort != null) {
                launchSpec.exposedPorts.add(params.exposedPort);
            }
        }
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        EntrypointCodeStudioBlockParams params = block.getParamsAs(EntrypointCodeStudioBlockParams.class);
        for (SimpleKeyValue script : params.scripts) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(script.key)) continue;
            CodeStudioMeta.TemplateExportResource exportResource = new CodeStudioMeta.TemplateExportResource();
            exportResource.localPath = script.key;
            exportSpec.resourcesMap.put(script.key, exportResource);
        }
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        CodeStudioBlock block = (CodeStudioBlock)JSON.deepCopy((Object)srcBlock);
        EntrypointCodeStudioBlockParams params = block.getParamsAs(EntrypointCodeStudioBlockParams.class);
        for (SimpleKeyValue script : params.scripts) {
            if (CodeStudioTemplatesService.isInTemplateResourcesDir(script.key)) continue;
            CodeStudioMeta.TemplateExportResource exportScript = exportSpec.resourcesMap.get(script.key);
            if (exportScript == null) {
                throw new IllegalArgumentException("Resource missing from export " + script.key);
            }
            script.key = exportScript.localPath;
        }
        return block;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    public static class EntrypointCodeStudioBlockParams
    implements CodeStudioBlockParams {
        public String label;
        public String entrypoint;
        public List<SimpleKeyValue> scripts = Lists.newArrayList();
        public CodeStudioMeta.ExposedCodeStudioPort exposedPort;
        public boolean useInWebapps;

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            if (this.exposedPort != null) {
                if (this.exposedPort.port == 0 || this.exposedPort.port > 65535) {
                    throw ErrorContext.ice((String)"Entrypoint port must be between 1 and 65535.");
                }
                if (StringUtils.isBlank((String)this.exposedPort.label)) {
                    throw ErrorContext.ice((String)"Exposed port label must not be empty.");
                }
            }
            for (SimpleKeyValue file : this.scripts) {
                if (StringUtils.isBlank((String)file.value)) {
                    throw ErrorContext.ice((String)"Entrypoint target script cannot be empty");
                }
                CodeStudioTemplatesService.getReadableFileOrThrow(file.key, templateVariablesContext, "Entrypoint script");
            }
        }
    }
}

