/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SparkConnection
extends AbstractSQLConnection
implements MetastoreDBBasedConnection {
    public static final String REGISTER_DATASET_PROP_PREFIX = "dku.spark.sql.register.dataset.";
    public static final String REGISTER_DATASET_PARTITION_PROP_PREFIX = "dku.spark.sql.register.partition.";
    private final transient SparkSQLConnectionPoolService connectionPoolService;
    public transient HadoopSettings hadoopSettings;
    public transient SparkSettings sparkSettings;
    public Params params = new Params();
    public static final String connectionType = "sparklivy";
    private static SparkSQLDialect dialect;
    private static final Logger logger;

    public SparkConnection(SparkSQLConnectionPoolService connectionPoolService) {
        this.connectionPoolService = connectionPoolService;
    }

    public String getClusterId() {
        return this.params.clusterId;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public boolean isProperSQL() {
        return false;
    }

    @Override
    public String getDatabaseName() {
        return this.params.db;
    }

    @Override
    public SparkSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new SparkSQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        throw new Error("Must not be called");
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    String getJdbcUrl() {
        throw new Error("Must not be called");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public SparkSQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) {
        SparkSQLConnectionData cd = new SparkSQLConnectionData(this, this.connectionPoolService);
        this.fillConnectionData(cd);
        return cd;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        throw new NotImplementedException();
    }

    static {
        logger = Logger.getLogger((String)"dip.spark.connection");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public int port = 8998;
        public String host;
        public String clusterId;
        public String db;
        public List<SimpleKeyValue> sparkconf = Lists.newArrayList();
        public String extraUrl;
        public boolean useUrl;
        public String customUrl;
        public String customDisplayedUrl;
        public boolean yarnCluster;
        public String sparkVersion;
        public int fetchSize;
        public SparkSettings.YarnClusterSettings yarnClusterSettings;
    }

    public static class SparkSQLConnectionData
    extends SQLConnectionProvider.AbstractSQLConnectionData {
        private final Params connectionParams;
        private final SparkSQLConnectionPoolService connectionPoolService;

        public SparkSQLConnectionData(SparkConnection connection, SparkSQLConnectionPoolService connectionPoolService) {
            super(ConnectionUtils.SQLConnectionType.SPARKLIVY, new SparkSQLDialect(), connection);
            this.connectionPoolService = connectionPoolService;
            this.connectionParams = (Params)JSON.deepCopy((Object)connection.params);
        }

        @Override
        public SparkConnection getConnection() {
            return (SparkConnection)super.getConnection();
        }

        @Override
        public SQLConnectionProvider.SQLConnectionWrapper buildConnection(AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            try {
                String partitionId;
                String datasetTableName;
                String datasetFullName;
                String clusterId = StringUtils.isBlank((String)projectKey) ? "__builtin__" : new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.HADOOP);
                String k8sClusterId = StringUtils.isBlank((String)projectKey) ? "__builtin__" : new ClusterSelector().getClusterForProject(projectKey, Cluster.ClusterArchitecture.KUBERNETES);
                logger.info((Object)("New spark connection clusterId=" + clusterId + " k8sClusterId=" + k8sClusterId));
                SparkSQLConnectionPoolService.SparkSQLConnection wrapper = this.connectionPoolService.take(clusterId, k8sClusterId, authCtx, this.connectionParams.db, this.connectionParams.sparkconf, projectKey);
                logger.info((Object)("Looking for datasets to register " + JSON.json((Object)this.connectionParams)));
                for (Object kv : this.connectionParams.sparkconf) {
                    if (!kv.key.startsWith(SparkConnection.REGISTER_DATASET_PROP_PREFIX)) continue;
                    datasetFullName = kv.key.substring(SparkConnection.REGISTER_DATASET_PROP_PREFIX.length());
                    datasetTableName = kv.value;
                    logger.info((Object)("   Found in conf : " + datasetFullName + " to register as " + datasetTableName));
                    partitionId = this.connectionParams.sparkconf.stream().filter(skv -> skv.key.equals(SparkConnection.REGISTER_DATASET_PARTITION_PROP_PREFIX + datasetFullName)).findFirst().map(skv -> skv.value).orElse(null);
                    wrapper.getLivyConnection().registerDataset(authCtx, wrapper.getSparkConnection().hadoopSettings, datasetFullName, datasetTableName, partitionId);
                }
                for (Object kv : this.connectionParams.properties) {
                    if (!kv.name.startsWith(SparkConnection.REGISTER_DATASET_PROP_PREFIX)) continue;
                    datasetFullName = kv.name.substring(SparkConnection.REGISTER_DATASET_PROP_PREFIX.length());
                    datasetTableName = kv.value;
                    logger.info((Object)("   Found in props : " + datasetFullName + " to register as " + datasetTableName));
                    partitionId = this.connectionParams.properties.stream().filter(prop -> prop.name.equals(SparkConnection.REGISTER_DATASET_PARTITION_PROP_PREFIX + datasetFullName)).findFirst().map(property -> property.value).orElse(null);
                    wrapper.getLivyConnection().registerDataset(authCtx, wrapper.getSparkConnection().hadoopSettings, datasetFullName, datasetTableName, partitionId);
                }
                return wrapper;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Could not get SparkLivy connection from the pool", e);
            }
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            return "com.dataiku.dip.spark.sparksql.RemoteSparkSQLHandler";
        }

        public void addProperty(AbstractSQLConnection.CustomDatabaseProperty prop) {
            this.connectionParams.properties.add(prop);
            this.getConnection().params.properties.add(prop);
        }

        @Override
        public SQLConnectionProvider.SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            throw new UnsupportedOperationException("Can access Spark from Spark via JDBC");
        }
    }
}

