/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public abstract class AppHomepageTile {
    public AppHomepageTileType type;
    public String prompt;
    public String help;
    public String helpTitle;
    public String visibilityCondition;

    public static void registerAdapter() {
        JSON.registerAdapter(AppHomepageTile.class, (Object)new JSON.Adapter<AppHomepageTile>(){

            public AppHomepageTile deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (!jsonObj.has("type") || jsonObj.getAsJsonPrimitive("type").isJsonNull()) {
                    throw new IllegalArgumentException("Missing tile type");
                }
                switch (jsonObj.getAsJsonPrimitive("type").getAsString()) {
                    case "UPLOAD_DATASET_SET_FILE": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, UploadDatasetSetFileTile.class);
                    }
                    case "MANAGED_FOLDER_ADD_FILE": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, ManagedFolderSetFileTile.class);
                    }
                    case "INLINE_DATASET_EDIT": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditInlineDatasetTile.class);
                    }
                    case "DATASET_EDIT_SETTINGS": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditAnyDatasetTile.class);
                    }
                    case "STREAMING_ENDPOINT_EDIT_SETTINGS": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditAnyStreamingEndpointTile.class);
                    }
                    case "FILES_BASED_DATASET_BROWSE_AND_PREVIEW": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditFSDatasetTile.class);
                    }
                    case "MANAGED_FOLDER_BROWSE": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditFolderTile.class);
                    }
                    case "CONNECTION_EXPLORER_TO_REPLACE_THE_SETTINGS_OF_A_DATASET_WITH_A_NEW_TABLE_REFERENCE": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, EditSQLDatasetTile.class);
                    }
                    case "DASHBOARD_LINK": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, DashboardLinkTile.class);
                    }
                    case "MANAGED_FOLDER_LINK": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, ManagedFolderLinkTile.class);
                    }
                    case "SCENARIO_RUN": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, RunScenarioTile.class);
                    }
                    case "INLINE_PYTHON_RUN": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, RunInlinePythonTile.class);
                    }
                    case "PROJECT_VARIABLES_EDIT": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, ProjectVariablesTile.class);
                    }
                    case "PERFORM_SCHEMA_PROPAGATION": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, PropagateSchemaTile.class);
                    }
                    case "DOWNLOAD_DATASET": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, DownloadDatasetTile.class);
                    }
                    case "DOWNLOAD_DASHBOARD_EXPORT": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, DownloadDashboardTile.class);
                    }
                    case "DOWNLOAD_MANAGED_FOLDER_FILE": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, DownloadManagedFolderTile.class);
                    }
                    case "DOWNLOAD_RMARKDOWN": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, DownloadReportTile.class);
                    }
                    case "VARIABLE_DISPLAY": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, VariableDisplayTile.class);
                    }
                    case "GUESS_TRAIN_DEPLOY": {
                        return (AppHomepageTile)jsonDeserializationContext.deserialize(jsonElement, GuessTrainDeployTile.class);
                    }
                }
                throw new IllegalArgumentException("Invalid tile type " + String.valueOf(jsonObj.get("type")));
            }

            public JsonElement serialize(AppHomepageTile tile, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)tile);
            }
        });
    }

    public static class GuessTrainDeployTile
    extends AppHomepageTile {
        public String modelId;
    }

    public static class VariableDisplayTile
    extends AppHomepageTile {
        public String content;
    }

    public static class DownloadReportTile
    extends AppHomepageTile {
        public String reportId;
        public Report.ReportOutputFormat format = Report.ReportOutputFormat.PDF_DOCUMENT;
    }

    public static class DownloadDashboardTile
    extends AppHomepageTile {
        public String dashboardId;
        public ExportFormat format;
    }

    public static class DownloadManagedFolderTile
    extends AppHomepageTile {
        public String folderId;
        public String itemPath;
    }

    public static class DownloadDatasetTile
    extends AppHomepageTile {
        public String datasetName;
        public ExportParams exportParams = new ExportParams();
    }

    public static class PropagateSchemaTile
    extends AppHomepageTile {
        public String datasetName;
        public PropagateSchemaTileBehavior behavior = PropagateSchemaTileBehavior.MANUAL;
        public JsonObject recipeUpdateOptions = new JsonObject();
        public List<PartitionDef> partitionByDim = Lists.newArrayList();
        public List<PartitionDef> partitionByComputable = Lists.newArrayList();
        public Set<String> excludedRecipes = Sets.newHashSet();
        public Set<String> markAsOkRecipes = Sets.newHashSet();
    }

    public static class PartitionDef {
        public String from;
        public String to;
    }

    public static enum PropagateSchemaTileBehavior {
        MANUAL,
        AUTO_NO_BUILD,
        AUTO_WITH_BUILDS;

    }

    public static class ProjectVariablesTile
    extends AppHomepageTile {
        public ProjectVariablesTileBehavior behavior = ProjectVariablesTileBehavior.MODAL;
        public String buttonText;
        public List<ParamDesc> params = Lists.newArrayList();
        public String html;
        public String js;
        public String module;
        public String python;
    }

    public static enum ProjectVariablesTileBehavior {
        INLINE_AUTO_SAVE,
        INLINE_EXPLICIT_SAVE,
        MODAL;

    }

    public static class RunInlinePythonTile
    extends AppHomepageTile {
        public String code;
        public String buttonText;
        public CodeEnvSelection envSelection = CodeEnvSelection.inherit();
        public PythonRunnableDesc desc = new PythonRunnableDesc();
    }

    public static class RunScenarioTile
    extends AppHomepageTile {
        public String scenarioId;
        public String buttonText;
    }

    public static class ManagedFolderLinkTile
    extends AppHomepageTile {
        public String folderId;
    }

    public static class DashboardLinkTile
    extends AppHomepageTile {
        public String dashboardId;
    }

    public static class EditSQLDatasetTile
    extends AppHomepageTile {
        public String datasetName;
        public EditSQLDatasetTileBehavior behavior = EditSQLDatasetTileBehavior.GO_TO_DATASET;
    }

    public static class EditFolderTile
    extends AppHomepageTile {
        public String folderId;
        public EditFolderTileBehavior behavior = EditFolderTileBehavior.GO_TO_FOLDER;
    }

    public static class EditFSDatasetTile
    extends AppHomepageTile {
        public String datasetName;
        public EditFSDatasetTileBehavior behavior = EditFSDatasetTileBehavior.GO_TO_DATASET;
    }

    public static class EditAnyStreamingEndpointTile
    extends AppHomepageTile {
        public String streamingEndpointId;
    }

    public static class EditAnyDatasetTile
    extends AppHomepageTile {
        public String datasetName;
    }

    public static class EditInlineDatasetTile
    extends AppHomepageTile {
        public String datasetName;
    }

    public static class ManagedFolderSetFileTile
    extends AppHomepageTile {
        public String folderId;
        ManagedFolderSetFileTileBehavior behavior = ManagedFolderSetFileTileBehavior.GO_TO_FOLDER;
    }

    public static class UploadDatasetSetFileTile
    extends AppHomepageTile {
        public String datasetName;
        public UploadDatasetSetFileTileBehavior behavior = UploadDatasetSetFileTileBehavior.GO_TO_DATASET;
    }

    public static enum EditSQLDatasetTileBehavior {
        GO_TO_DATASET,
        MODAL_BROWSE;

    }

    public static enum EditFolderTileBehavior {
        GO_TO_FOLDER,
        INLINE_BROWSE,
        MODAL_BROWSE;

    }

    public static enum EditFSDatasetTileBehavior {
        GO_TO_DATASET,
        INLINE_BROWSE_ONLY,
        INLINE_BROWSE_AND_REDETECT,
        INLINE_BROWSE_REDETECT_AND_INFER,
        MODAL_BROWSE_REDETECT_AND_INFER;

    }

    public static enum ManagedFolderSetFileTileBehavior {
        GO_TO_FOLDER,
        INLINE_UPLOAD;

    }

    public static enum UploadDatasetSetFileTileBehavior {
        GO_TO_DATASET,
        INLINE_UPLOAD_ONLY,
        INLINE_UPLOAD_AND_REDETECT,
        INLINE_UPLOAD_REDETECT_AND_INFER;

    }

    public static enum AppHomepageTileType {
        UPLOAD_DATASET_SET_FILE,
        INLINE_DATASET_EDIT,
        MANAGED_FOLDER_ADD_FILE,
        DATASET_EDIT_SETTINGS,
        STREAMING_ENDPOINT_EDIT_SETTINGS,
        FILES_BASED_DATASET_BROWSE_AND_PREVIEW,
        MANAGED_FOLDER_BROWSE,
        CONNECTION_EXPLORER_TO_REPLACE_THE_SETTINGS_OF_A_DATASET_WITH_A_NEW_TABLE_REFERENCE,
        PROJECT_VARIABLES_EDIT,
        PERFORM_SCHEMA_PROPAGATION,
        GUESS_TRAIN_DEPLOY,
        SCENARIO_RUN,
        INLINE_PYTHON_RUN,
        DASHBOARD_LINK,
        DOWNLOAD_DATASET,
        DOWNLOAD_RMARKDOWN,
        MANAGED_FOLDER_LINK,
        DOWNLOAD_MANAGED_FOLDER_FILE,
        DOWNLOAD_DASHBOARD_EXPORT,
        VARIABLE_DISPLAY;

    }
}

