/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProjectVersionTags {
    @JSON.FileTransient
    public String projectKey;
    private Map<String, VersionTag> tags = new HashMap<String, VersionTag>();

    public ProjectVersionTags withProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    private String getKey(ITaggingService.TaggableType taggableType, String objectId) {
        return taggableType.name() + "." + objectId;
    }

    public VersionTag getTag(ITaggingService.TaggableType taggableType, String objectId) {
        return this.tags.get(this.getKey(taggableType, objectId));
    }

    public VersionTag getTag(TaggableObjectsService.TaggableObject o) {
        return this.getTag(o.getTaggableType(), o.getId());
    }

    public void setTag(ITaggingService.TaggableType taggableType, String objectId, VersionTag tag) {
        this.tags.put(this.getKey(taggableType, objectId), tag);
    }

    public void setTag(TaggableObjectsService.TaggableObject o, VersionTag tag) {
        this.setTag(o.getTaggableType(), o.getId(), tag);
    }

    public static void registerAdapter() {
        JSON.registerAdapter(ProjectVersionTags.class, (Object)new JsonSerializer<ProjectVersionTags>(){

            public JsonElement serialize(ProjectVersionTags versionTags, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                if (!JSON.excludesFileTransient((JsonSerializationContext)ctx)) {
                    jsonObj.addProperty("projectKey", versionTags.projectKey);
                }
                List sortedKeys = versionTags.tags.keySet().stream().sorted().collect(Collectors.toList());
                JsonObject map = new JsonObject();
                for (String key : sortedKeys) {
                    VersionTag tag = versionTags.tags.get(key);
                    if (tag == null) {
                        map.add(key, (JsonElement)JsonNull.INSTANCE);
                        continue;
                    }
                    map.add(key, ctx.serialize((Object)tag));
                }
                jsonObj.add("tags", (JsonElement)map);
                return jsonObj;
            }
        });
    }
}

