/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.custom;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PluginSettingsResolver {
    private static boolean remoteIsJEK;
    private static String remoteURL;
    private static String remoteTicket;
    private static String remoteCert;
    private IPluginsRegistryService pluginsRegistryService;
    private PluginParameterSetsService pluginPresetsService;
    private final AuthCtx authCtx;
    private final String projectKey;
    private static Logger logger;

    public static void setupRemoteResolution(boolean remoteIsJEK, String remoteURL, String remoteCert, String remoteTicket) {
        logger.info((Object)("Setting up remote plugin settings access to " + remoteURL + " jek=" + remoteIsJEK));
        PluginSettingsResolver.remoteIsJEK = remoteIsJEK;
        PluginSettingsResolver.remoteURL = remoteURL;
        PluginSettingsResolver.remoteCert = remoteCert;
        PluginSettingsResolver.remoteTicket = remoteTicket;
    }

    public PluginSettingsResolver(AuthCtx authCtx, @Nullable String projectKey) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
    }

    public PluginSettingsResolver withPluginsRegistry(IPluginsRegistryService pluginsRegistryService) {
        this.pluginsRegistryService = pluginsRegistryService;
        return this;
    }

    private void ensureInjected() {
        if (this.pluginsRegistryService == null) {
            this.pluginsRegistryService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        }
        if (this.pluginPresetsService == null) {
            this.pluginPresetsService = (PluginParameterSetsService)SpringUtils.getBean(PluginParameterSetsService.class);
        }
    }

    public ResolvedSettings getPluginSettings(List<ParamDesc> params, JsonObject elementConfig, String pluginId) throws IOException, DKUSecurityException {
        if (StringUtils.isNotBlank((String)remoteURL)) {
            return this.getSettingsViaAPI(params, elementConfig, pluginId);
        }
        this.ensureInjected();
        return this.getPluginSettings_internal(params, elementConfig, pluginId);
    }

    public PluginSettings getAndMergePluginSettings(String pluginId) throws IOException, DKUSecurityException {
        this.ensureInjected();
        return this.getAndMergeSettings_internal(pluginId);
    }

    private ResolvedSettings getSettingsViaAPI(List<ParamDesc> params, JsonObject elementConfig, String pluginId) throws IOException {
        logger.info((Object)("Retrieve plugin settings via api on " + remoteURL + " (" + (remoteIsJEK ? "jek" : "backend") + "), for " + pluginId + " in " + this.projectKey));
        try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient(remoteURL, remoteCert, remoteTicket);){
            String apiPath = remoteIsJEK ? "/kernel" : "/dip/api";
            ResolvedSettings resolvedSettings = (ResolvedSettings)apiClient.postFormToJSON(apiPath + "/tintercom/plugins/get-plugin-settings", ResolvedSettings.class, new Object[]{"projectKey", this.projectKey, "params", JSON.json(params), "elementConfig", JSON.json((Object)elementConfig), "pluginId", pluginId});
            return resolvedSettings;
        }
    }

    private ResolvedSettings getPluginSettings_internal(List<ParamDesc> params, JsonObject elementConfig, String pluginId) throws IOException, DKUSecurityException {
        if (StringUtils.isNotBlank((String)remoteURL)) {
            return this.getSettingsViaAPI(params, elementConfig, pluginId);
        }
        PluginSettings settings = this.getAndMergeSettings_internal(pluginId);
        JsonObject config = (JsonObject)JSON.deepCopy((Object)elementConfig);
        JsonObject pluginConfig = (JsonObject)JSON.deepCopy((Object)settings.config);
        PluginDesc pluginDesc = this.pluginsRegistryService.getDesc(pluginId);
        for (ParamDesc param : params) {
            JsonElement paramValue;
            if (param.type == ParamDesc.Type.PRESET) {
                paramValue = elementConfig.get(param.name);
                if (paramValue == null || paramValue.isJsonNull()) {
                    logger.debug((Object)"Preset is not defined, keeping as null");
                    config.add(param.name, (JsonElement)new JsonObject());
                    pluginConfig.add(param.name, (JsonElement)new JsonObject());
                    continue;
                }
                PresetChoice choice = (PresetChoice)JSON.parse((String)JSON.json((Object)paramValue), PresetChoice.class);
                this.handlePreset(param, choice, pluginId, settings, config, pluginConfig);
                continue;
            }
            if (param.type != ParamDesc.Type.PRESETS) continue;
            paramValue = elementConfig.get(param.name);
            if (paramValue == null || paramValue.isJsonNull()) {
                logger.debug((Object)"Preset list is not defined, keeping as null");
                config.add(param.name, (JsonElement)new JsonArray());
                pluginConfig.add(param.name, (JsonElement)new JsonArray());
                continue;
            }
            List choices = (List)JSON.parse((String)JSON.json((Object)paramValue), (TypeToken)new TypeToken<List<PresetChoice>>(){});
            JsonArray configs = new JsonArray();
            JsonArray pluginConfigs = new JsonArray();
            for (PresetChoice choice : choices) {
                JsonObject subConfig = new JsonObject();
                JsonObject subPluginConfig = new JsonObject();
                this.handlePreset(param, choice, pluginId, settings, subConfig, subPluginConfig);
                configs.add(subConfig.get(param.name));
                pluginConfigs.add(subPluginConfig.get(param.name));
            }
            config.add(param.name, (JsonElement)configs);
            pluginConfig.add(param.name, (JsonElement)pluginConfigs);
        }
        if (StringUtils.isNotBlank((String)this.projectKey)) {
            pluginConfig = PluginConfigUtils.getExpanded(pluginConfig, pluginDesc.params, this.projectKey);
            config = PluginConfigUtils.getExpanded(config, params, this.projectKey);
        }
        return new ResolvedSettings(config, pluginConfig);
    }

    private void handlePreset(ParamDesc param, PresetChoice choice, String pluginId, PluginSettings settings, JsonObject config, JsonObject pluginConfig) throws IOException, DKUSecurityException {
        if (choice.mode == null) {
            logger.debug((Object)"Preset type not set, keeping as null");
            config.add(param.name, (JsonElement)new JsonObject());
            pluginConfig.add(param.name, (JsonElement)new JsonObject());
            return;
        }
        switch (choice.mode) {
            case NONE: {
                logger.debug((Object)"Preset is set to empty, keeping as null");
                config.add(param.name, (JsonElement)new JsonObject());
                pluginConfig.add(param.name, (JsonElement)new JsonObject());
                break;
            }
            case INLINE: {
                String elementType = "parameter-set-" + pluginId + "-" + param.parameterSetId;
                LoadedParameterSet parameterSetDesc = (LoadedParameterSet)this.pluginPresetsService.getOrNull(elementType);
                if (parameterSetDesc == null) {
                    throw new IllegalArgumentException(elementType + " is not a registered preset type");
                }
                if (!PluginSettingsResolver.hasPluginParameterSetPrivilege(this.authCtx, pluginId, parameterSetDesc.id, Privileges.PluginParameterSetLevelPrivilegeType.INLINE)) {
                    throw new DKUSecurityException("Preset type " + elementType + " cannot be inline");
                }
                config.add(param.name, (JsonElement)choice.inlinedConfig);
                pluginConfig.add(param.name, (JsonElement)choice.inlinedPluginConfig);
                break;
            }
            case PRESET: {
                String presetName = choice.name;
                if (StringUtils.isBlank((String)presetName)) {
                    logger.debug((Object)"Preset name is empty, keeping as null");
                    config.add(param.name, (JsonElement)new JsonObject());
                    pluginConfig.add(param.name, (JsonElement)new JsonObject());
                    break;
                }
                logger.info((Object)("Looking for preset " + presetName + " in parameter-set " + param.parameterSetId));
                PluginPreset preset = this.pluginPresetsService.findPresetInListOfPresets(presetName, param.parameterSetId, settings.presets);
                if (preset == null) {
                    throw new IllegalArgumentException("Preset " + presetName + " in parameter-set " + param.parameterSetId + " does not exist");
                }
                LoadedParameterSet parameterSetDesc = (LoadedParameterSet)this.pluginPresetsService.getOrNull(preset.type);
                if (parameterSetDesc == null) {
                    throw new IllegalArgumentException("Preset " + preset.name + " is of unregistered type");
                }
                if (!PluginSettingsResolver.hasPluginPrivilege(this.authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN) && !PluginSettingsResolver.hasPluginPresetPrivilege(this.authCtx, pluginId, this.projectKey, presetName, parameterSetDesc.id, Privileges.PluginPresetLevelPrivilegeType.USE)) {
                    throw new DKUSecurityException("Preset " + presetName + " is not freely usable by " + this.authCtx.toString());
                }
                if (StringUtils.isNotBlank((String)this.projectKey)) {
                    config.add(param.name, (JsonElement)PluginConfigUtils.getExpandedAndResolved(this.authCtx, preset.config, parameterSetDesc.desc.params, this.projectKey, pluginId, parameterSetDesc.id, preset.name));
                    pluginConfig.add(param.name, (JsonElement)PluginConfigUtils.getExpanded(preset.pluginConfig, parameterSetDesc.desc.pluginParams, this.projectKey));
                    break;
                }
                config.add(param.name, (JsonElement)PluginConfigUtils.getResolved(this.authCtx, preset.config, parameterSetDesc.desc.params, pluginId, parameterSetDesc.id, preset.name));
                pluginConfig.add(param.name, (JsonElement)preset.pluginConfig);
                break;
            }
            default: {
                throw new Error("Unreachable");
            }
        }
    }

    private PluginSettings getAndMergeSettings_internal(String pluginId) throws IOException {
        PluginSettings settings = this.pluginsRegistryService.getSettings(pluginId);
        if (StringUtils.isNotBlank((String)this.projectKey)) {
            logger.info((Object)"Checking project-level settings for overriden presets and additional presets");
            PluginSettings projectSettings = this.pluginsRegistryService.getProjectSettings(pluginId, this.projectKey);
            HashMap projectPresets = Maps.newHashMap();
            for (PluginPreset preset : projectSettings.presets) {
                projectPresets.put(preset.name, preset);
            }
            ArrayList presets = Lists.newArrayList();
            presets.addAll(projectPresets.values());
            for (PluginPreset preset : settings.presets) {
                if (projectPresets.containsKey(preset.name) && ((PluginPreset)projectPresets.get((Object)preset.name)).type.equals(preset.type)) continue;
                presets.add(preset);
            }
            settings.presets = presets;
        }
        return settings;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static boolean hasPluginPrivilege(AuthCtx authCtx, String pluginId, Privileges.PluginLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        switch (2.$SwitchMap$com$dataiku$dip$logging$MainLoggingConfigurator$ProcessType[ClusterSelector.getContext().ordinal()]) {
            case 1: 
            case 2: {
                permissionsService = (PermissionsService)SpringUtils.getBean(PermissionsService.class);
                return permissionsService.hasPluginPrivilege(authCtx, pluginId, privilege);
            }
            case 3: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = CDEProcessUtils.newIntercomAPIClient();
                        try {
                            var6_20 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/tintercom/permissions/has-plugin-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl26
                        }
                        catch (Throwable var6_21) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var7_27) {
                                    var6_21.addSuppressed(var7_27);
                                }
                            }
                            throw var6_21;
                        }
                        apiClient.close();
lbl26:
                        // 2 sources

                        return var6_20;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 4: 
            case 5: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());
                        try {
                            var6_23 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-plugin-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl56
                        }
                        catch (Throwable var6_24) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var7_28) {
                                    var6_24.addSuppressed(var7_28);
                                }
                            }
                            throw var6_24;
                        }
                        apiClient.close();
lbl56:
                        // 2 sources

                        return var6_23;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 6: 
            case 7: {
                backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);
                try {
                    var5_18 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-plugin-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)authCtx), "pluginId", pluginId, "privilege", privilege.toString()})).ok;
                    return var5_18;
                }
                finally {
                    apiClient.close();
                }
            }
            case 8: {
                throw new Error("DSS Process type not set, cannot check cluster access");
            }
        }
        throw new Error("Unreachable");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static boolean hasPluginPresetPrivilege(AuthCtx authCtx, String pluginId, String projectKey, String presetName, String parameterSetId, Privileges.PluginPresetLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        switch (2.$SwitchMap$com$dataiku$dip$logging$MainLoggingConfigurator$ProcessType[ClusterSelector.getContext().ordinal()]) {
            case 1: 
            case 2: {
                permissionsService = (PermissionsService)SpringUtils.getBean(PermissionsService.class);
                t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();
                try {
                    var8_18 = permissionsService.hasPluginPresetPrivilege(authCtx, pluginId, projectKey, presetName, parameterSetId, privilege);
                    return var8_18;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            case 3: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = CDEProcessUtils.newIntercomAPIClient();
                        try {
                            var9_27 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/tintercom/permissions/has-plugin-preset-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "projectKey", projectKey, "presetName", presetName, "parameterSetId", parameterSetId, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl33
                        }
                        catch (Throwable var9_28) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var10_34) {
                                    var9_28.addSuppressed(var10_34);
                                }
                            }
                            throw var9_28;
                        }
                        apiClient.close();
lbl33:
                        // 2 sources

                        return var9_27;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 4: 
            case 5: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());
                        try {
                            var9_30 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-plugin-preset-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "projectKey", projectKey, "presetName", presetName, "parameterSetId", parameterSetId, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl63
                        }
                        catch (Throwable var9_31) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var10_35) {
                                    var9_31.addSuppressed(var10_35);
                                }
                            }
                            throw var9_31;
                        }
                        apiClient.close();
lbl63:
                        // 2 sources

                        return var9_30;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 6: 
            case 7: {
                backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);
                try {
                    var8_24 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-plugin-preset-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)authCtx), "pluginId", pluginId, "projectKey", projectKey, "presetName", presetName, "parameterSetId", parameterSetId, "privilege", privilege.toString()})).ok;
                    return var8_24;
                }
                finally {
                    apiClient.close();
                }
            }
            case 8: {
                throw new Error("DSS Process type not set, cannot check cluster access");
            }
        }
        throw new Error("Unreachable");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static boolean hasPluginParameterSetPrivilege(AuthCtx authCtx, String pluginId, String parameterSetName, Privileges.PluginParameterSetLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        switch (2.$SwitchMap$com$dataiku$dip$logging$MainLoggingConfigurator$ProcessType[ClusterSelector.getContext().ordinal()]) {
            case 1: 
            case 2: {
                permissionsService = (PermissionsService)SpringUtils.getBean(PermissionsService.class);
                return permissionsService.hasPluginParameterSetPrivilege(authCtx, pluginId, parameterSetName, privilege);
            }
            case 3: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = CDEProcessUtils.newIntercomAPIClient();
                        try {
                            var7_21 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/tintercom/permissions/has-plugin-parameter-set-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "parameterSetName", parameterSetName, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl26
                        }
                        catch (Throwable var7_22) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var8_28) {
                                    var7_22.addSuppressed(var8_28);
                                }
                            }
                            throw var7_22;
                        }
                        apiClient.close();
lbl26:
                        // 2 sources

                        return var7_21;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 4: 
            case 5: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());
                        try {
                            var7_24 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-plugin-parameter-set-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"pluginId", pluginId, "parameterSetName", parameterSetName, "privilege", privilege.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl56
                        }
                        catch (Throwable var7_25) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var8_29) {
                                    var7_25.addSuppressed(var8_29);
                                }
                            }
                            throw var7_25;
                        }
                        apiClient.close();
lbl56:
                        // 2 sources

                        return var7_24;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 6: 
            case 7: {
                backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);
                try {
                    var6_19 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-plugin-parameter-set-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)authCtx), "pluginId", pluginId, "parameterSetName", parameterSetName, "privilege", privilege.toString()})).ok;
                    return var6_19;
                }
                finally {
                    apiClient.close();
                }
            }
            case 8: {
                throw new Error("DSS Process type not set, cannot check cluster access");
            }
        }
        throw new Error("Unreachable");
    }

    static {
        logger = Logger.getLogger((String)"dip.plugin.presets");
    }

    public static class ResolvedSettings {
        public final JsonObject config;
        public final JsonObject pluginConfig;

        public ResolvedSettings(JsonObject config, JsonObject pluginConfig) {
            this.config = config;
            this.pluginConfig = pluginConfig;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof ResolvedSettings)) {
                return false;
            }
            ResolvedSettings that = (ResolvedSettings)o;
            return Objects.equals(this.config, that.config) && Objects.equals(this.pluginConfig, that.pluginConfig);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.config);
            result = 31 * result + Objects.hashCode(this.pluginConfig);
            return result;
        }
    }

    public static class PresetChoice {
        public PresetChoiceMode mode;
        public String name;
        public JsonObject inlinedConfig;
        public JsonObject inlinedPluginConfig;
    }

    public static enum PresetChoiceMode {
        NONE,
        PRESET,
        INLINE;

    }
}

