/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.IRowsDAO;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.MetaComputer;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.RowsDAOH2Impl;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Verifier;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Writer
implements AutoCloseable {
    public static final int CANDIDATE_TABLE_ID = 0;
    public static final int QUERY_TABLE_ID = 1;
    private final RowFactory rowFactory;
    private final StreamColumnFactory columnFactory;
    private final List<AbstractInitializedRunner.Input> inputs;
    private final ProcessorOutput output;
    private final MetaComputer metaComputer;
    public final IRowsDAO rowsDAO;
    private final JoinType type;
    private final boolean isDebug;
    private List<ColumnWithDesc> columns;
    private int cachedQueryIndex = -1;
    private Map<String, String> cachedQueryRow;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fuzzyjoin.Writer");

    public Writer(List<AbstractInitializedRunner.Input> inputs, AbstractInitializedRunner.Output output, FuzzyJoinRecipePayloadParams payload, JobActivity activity, boolean debugMode) throws Exception {
        this.inputs = inputs;
        this.output = new ProcessorOutputToSIP(output.out);
        this.rowFactory = output.rf;
        this.columnFactory = output.cf;
        this.metaComputer = new MetaComputer(payload);
        this.type = payload.getJoinDescriptor().type;
        this.isDebug = debugMode;
        try {
            this.rowsDAO = new RowsDAOH2Impl(activity, payload);
        }
        catch (Exception e) {
            logger.info((Object)"H2 database could not be initialised", (Throwable)e);
            throw e;
        }
        this.buildOutputColumns(payload.getSelectedColumns());
    }

    @Override
    public void close() throws Exception {
        this.emitUnmatchedRows();
        this.rowsDAO.close();
        this.output.lastRowEmitted();
    }

    private boolean shouldEmitUnmatchedRows(int tableId) {
        JoinType specificTableJoinType = tableId == 0 ? JoinType.LEFT : JoinType.RIGHT;
        return !this.isDebug && (specificTableJoinType.equals((Object)this.type) || JoinType.FULL.equals((Object)this.type));
    }

    private void emitUnmatchedRows() {
        try {
            this.emitUnmatchedRows(0);
            this.emitUnmatchedRows(1);
        }
        catch (Exception e) {
            logger.error((Object)"Failed outputting the unmatched rows", (Throwable)e);
        }
    }

    private void emitUnmatchedRows(int tableId) throws Exception {
        if (!this.shouldEmitUnmatchedRows(tableId)) {
            return;
        }
        List<Map<String, String>> unmatchedRows = this.rowsDAO.getUnmatchedRows(tableId);
        for (Map<String, String> unmatchedRow : unmatchedRows) {
            this.output.emitRow(this.transformToOutputRow(tableId, unmatchedRow));
        }
    }

    private Row transformToOutputRow(int table, Map<String, String> unmatchedRow) {
        Row result = this.rowFactory.row();
        for (ColumnWithDesc columnWithDesc : this.columns) {
            AbstractInitializedRunner.Input input = this.inputs.get(columnWithDesc.desc.table);
            StreamColumn inputCol = input.cf.column(columnWithDesc.desc.name);
            if (columnWithDesc.desc.table != table) continue;
            result.put(columnWithDesc.column, unmatchedRow.get(inputCol.getName()));
        }
        return result;
    }

    public int countRows(int table) {
        try {
            return this.rowsDAO.countRows(table);
        }
        catch (SQLException e) {
            logger.error((Object)"Cannot count rows in specified table", (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(Verifier.VerifierResult result) throws Exception {
        if (result.isMatch || this.isDebug) {
            try {
                Row row = this.join(result.query, result.candidate);
                if (this.metaComputer.hasMeta) {
                    String meta = JSON.json(this.metaComputer.getMeta(result));
                    row.put((Column)this.columnFactory.column("meta"), meta);
                }
                Writer writer = this;
                synchronized (writer) {
                    this.output.emitRow(row);
                }
            }
            catch (SQLException e) {
                logger.info((Object)"Matching rows could not be joined", (Throwable)e);
                throw e;
            }
        }
    }

    private void buildOutputColumns(List<ColumnDesc> selectedColumns) {
        this.columns = new ArrayList<ColumnWithDesc>();
        for (ColumnDesc columnDesc : selectedColumns) {
            ColumnWithDesc columnWithDesc = new ColumnWithDesc();
            String key = columnDesc.alias != null ? columnDesc.alias : columnDesc.name;
            columnWithDesc.column = this.columnFactory.column(key);
            columnWithDesc.desc = columnDesc;
            this.columns.add(columnWithDesc);
        }
    }

    private Row join(Record query, Record candidate) throws SQLException {
        if (query.getIndex() != this.cachedQueryIndex) {
            this.cachedQueryRow = this.rowsDAO.getRow(query.getTable(), query.getIndex());
            this.cachedQueryIndex = query.getIndex();
        }
        Map<String, String> candidateRow = this.rowsDAO.getRow(candidate.getTable(), candidate.getIndex());
        Row result = this.rowFactory.row();
        for (ColumnWithDesc columnWithDesc : this.columns) {
            AbstractInitializedRunner.Input input = this.inputs.get(columnWithDesc.desc.table);
            StreamColumn inputCol = input.cf.column(columnWithDesc.desc.name);
            Map<String, String> row = columnWithDesc.desc.table == query.getTable() ? this.cachedQueryRow : candidateRow;
            result.put(columnWithDesc.column, row.get(inputCol.getName()));
        }
        return result;
    }

    public void populateMatchedRows(Map<Integer, Collection<Integer>> matchedRowsByTable, List<Future<Map<Integer, List<Integer>>>> futures) throws InterruptedException, ExecutionException {
        if (this.isDebug) {
            return;
        }
        for (Future<Map<Integer, List<Integer>>> future : futures) {
            Map<Integer, List<Integer>> matchedRowsByTableAfterQuery = future.get();
            for (Map.Entry<Integer, List<Integer>> rowsByTable : matchedRowsByTableAfterQuery.entrySet()) {
                matchedRowsByTable.putIfAbsent(rowsByTable.getKey(), new HashSet());
                matchedRowsByTable.get(rowsByTable.getKey()).addAll((Collection<Integer>)rowsByTable.getValue());
            }
        }
    }

    public void setRowsAsMatch(Map<Integer, Collection<Integer>> matchedRowsByTable) throws SQLException {
        if (this.isDebug) {
            return;
        }
        for (Map.Entry<Integer, Collection<Integer>> matchedRows : matchedRowsByTable.entrySet()) {
            logger.info((Object)String.format("Setting %d rows as match for table: %d", matchedRows.getValue().size(), matchedRows.getKey()));
            this.rowsDAO.setRowAsMatch(matchedRows.getKey(), matchedRows.getValue());
        }
    }

    private static class ColumnWithDesc {
        Column column;
        ColumnDesc desc;

        private ColumnWithDesc() {
        }
    }
}

