/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PartitionsView
extends AbstractFlowTool.FlowView {
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    private PartitionsViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.partitions");

    public PartitionsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized PartitionsViewState computeState() throws Exception {
        this.state = new PartitionsViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                if (!sd.isPartitioned()) continue;
                String nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                try {
                    Dataset dataset = Dataset.fromSerialized(sd.getFullId(), sd);
                    DatasetMetricsStatusService.DatasetSummaryStatus cachedStatus = this.datasetMetricsStatusService.getCachedSummaryStatus(dataset);
                    this.add(nodeId, cachedStatus.partitions);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset connection   ", (Throwable)e);
                    this.add(nodeId, -1);
                }
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, int partitions) {
        this.state.valueByNode.put(nodeId, partitions);
    }

    public class PartitionsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, Integer> valueByNode = new HashMap<String, Integer>();
        public Collection<String> focused = new HashSet<String>();
    }
}

