/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;
import java.util.TreeMap;

public abstract class AbstractCountValuesAggregation
extends WindowAggregation {
    protected TreeMap<Object, Integer> valueCounts;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, Type.BIGINT);
    }

    public AbstractCountValuesAggregation(Column column, Column result, SchemaColumn schemaColumn) {
        super(column, result, schemaColumn, AbstractCountValuesAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.valueCounts = new TreeMap(RowValueAccessorFactory.getComparator(schemaColumn, column, true, RowsComparator.NullsOrdering.NULLS_LAST));
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.valueCounts.clear();
    }

    @Override
    public void expandInternal(Object value) {
        if (value != null) {
            if (this.valueCounts.containsKey(value)) {
                this.valueCounts.put(value, 1 + this.valueCounts.get(value));
            } else {
                this.valueCounts.put(value, 1);
            }
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        if (value != null && this.valueCounts.containsKey(value)) {
            int c2 = this.valueCounts.get(value) - 1;
            if (c2 == 0) {
                this.valueCounts.remove(value);
            } else {
                this.valueCounts.put(value, c2);
            }
        }
    }
}

