/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetMetric;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValuesInSetRule
extends AbstractMultiColumnRule {
    public static final String TYPE = "ValuesInSetRule";
    public final List<String> columns = new ArrayList<String>();
    public final List<String> valueSet = new ArrayList<String>();
    private transient Set<String> whitelistedValues;

    @Nonnull
    public Set<String> getWhitelistedValues() {
        if (this.whitelistedValues == null) {
            this.whitelistedValues = new HashSet<String>(this.valueSet);
        }
        return this.whitelistedValues;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    private ValuesInSetMetric getMetricForOneColumn(String column) {
        return new ValuesInSetMetric(this.getId(), column, this.valueSet);
    }

    @Override
    protected List<Metric> getMetricsForOneColumn(String column) {
        return List.of(this.getMetricForOneColumn(column));
    }

    @Override
    protected AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        ValuesInSetMetric metric = this.getMetricForOneColumn(column);
        List<String> result = ReadMetricValueHelper.readStringArrayMetricsValue(context, metric.id);
        if (result.isEmpty()) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, "All column values in approved list");
        }
        if (result.size() > metric.maxOutlierCount) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "More than " + metric.maxOutlierCount + " unexpected column values found: " + String.join((CharSequence)", ", result.subList(0, metric.maxOutlierCount)) + "...");
        }
        String values = result.size() == 1 ? "column value" : "column values";
        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, result.size() + " unexpected " + values + " found: " + String.join((CharSequence)", ", result));
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Override
    public void accept(FailedRowsExtractRuleVisitor visitor) {
        visitor.visit(this);
    }
}

